package com.biz.crm.customer.controller;


import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerMsgController")
@Api(tags = "客户信息")
@CrmGlobalLog
public class MdmCustomerMsgController {

    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;


    @ApiOperation(value = "客户信息页面查询主列表（其它功能请勿使用）")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMsgRespVo>> selectPage(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        PageResult<MdmCustomerMsgRespVo> result = mdmCustomerMsgService.findList(mdmCustomerMsgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "分页查询")
    @PostMapping("/page")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMsgRespVo>> page(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        //TODO 这里是提供出去的分页选择列表，可以重写一个简单的查询，提高查询效率
        PageResult<MdmCustomerMsgRespVo> result = mdmCustomerMsgService.findList(mdmCustomerMsgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "产品销售报表查询")
    @PostMapping("/findPageList")
    @CrmDictMethod
    public Result<PageResult<CustomerProductRespVo>> findPageList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo){
        PageResult<CustomerProductRespVo> pageList = mdmCustomerMsgService.findPageList(mdmCustomerMsgReqVo);
        return Result.ok(pageList);
    }

    @ApiOperation(value = "客户销售报表查询")
    @PostMapping("/findCustomerPageList")
    @CrmDictMethod
    public Result<PageResult<CustomerSaleRespVo>> findCustomerPageList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo){
        PageResult<CustomerSaleRespVo> list = mdmCustomerMsgService.findCustomerPageList(mdmCustomerMsgReqVo);
        return Result.ok(list);
    }

    @ApiOperation("根据组织编码获取当前层级所有客户编码集合")
    @PostMapping("/findByOrgCodeList")
    public Result<List<String>> findByOrgCodeList(@RequestBody List<String> list) {
        return Result.ok(mdmCustomerMsgService.findByOrgCodeList(list));
    }

    @ApiOperation(value = "查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "customerCode", value = "客户编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmCustomerMsgRespVo> query(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "customerCode", required = false) String customerCode) {
        MdmCustomerMsgRespVo model = mdmCustomerMsgService.query(id, customerCode);
        return Result.ok(model);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<MdmCustomerMsgRespVo> save(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgService.save(mdmCustomerMsgReqVo);
        return Result.ok(mdmCustomerMsgService.query(null, mdmCustomerMsgReqVo.getCustomerCode()));
    }

    @ApiOperation(value = "新增并提交流程")
    @PostMapping("/saveAndSubmit")
    public Result<Object> saveAndSubmit(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(mdmCustomerMsgService.saveAndSubmit(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgService.update(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新并提交")
    @PostMapping("/updateAndSubmit")
    public Result<Object> updateAndSubmit(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgService.updateAndSubmit(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "批量删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setIds(ids);
        mdmCustomerMsgService.deleteBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "启用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setIds(ids);
        mdmCustomerMsgService.enableBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "禁用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setIds(ids);
        mdmCustomerMsgService.disableBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }


    @ApiOperation("根据客户编码修改客户组织")
    @PostMapping("/updateOrgCodeByCondition")
    public Result<Object> updateOrgCodeByCondition(@RequestBody MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        mdmCustomerMsgService.updateOrgCodeByCondition(mdmUpdateCusOrgCodeReqVo);
        return Result.ok();
    }

    @ApiOperation("批量修改客户的企业组织")
    @PostMapping("/batchUpdateCustomerOrg")
    public Result<Object> batchUpdateCustomerOrg(@RequestBody MdmOrgCustomerUpdateReqVo reqVo) {
        mdmCustomerMsgService.batchUpdateCustomerOrg(reqVo);
        return Result.ok();
    }

    @ApiOperation("根据组织编码查询当前及下级组织的客户")
    @PostMapping("/findCurrentAndSubCustomerList")
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubCustomerList(@RequestBody MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List<MdmCustomerMsgRespVo> currentAndSubCustomerList = mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        return Result.ok(currentAndSubCustomerList);
    }

    @ApiOperation(value = "客户下拉框")
    @PostMapping("/findCustomerSelectList")
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo reqVo) {
        return Result.ok(mdmCustomerMsgService.list(reqVo));
    }

    @ApiOperation(value = "客户下拉框（限制数量）")
    @PostMapping("/select")
    public Result<List<MdmCustomerMsgSelectRespVo>> select(@RequestBody MdmCustomerMsgSelectReqVo reqVo) {
        return Result.ok(mdmCustomerMsgService.findCustomerSelectList(reqVo));
    }

    @ApiOperation(value = "客户下拉框（用户管理页面使用）")
    @PostMapping("/findCustomerNotRelateUserSelectList")
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerNotRelateUserSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(mdmCustomerMsgService.findCustomerNotRelateUserSelectList(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value = "条件查询客户编码")
    @PostMapping("/findCustomerCodeConditionList")
    public Result<List<String>> findCustomerCodeConditionList(@RequestBody CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        return Result.ok(mdmCustomerMsgService.findCustomerCodeConditionList(customerCodeConditionReqVo));
    }

    @ApiOperation("根据职位id或职位编码查询对应客户信息")
    @PostMapping("/findPositionCustomerList")
    public Result<List<MdmCustomerMsgRespVo>> findPositionCustomerList(@RequestBody MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return Result.ok(mdmCustomerMsgService.findPositionCustomerList(mdmPositionCustomerSearchReqVo));
    }

    @ApiOperation("当前及下级职位编码对应的客户集合")
    @PostMapping("/findCurrentAndSubPositionCustomer")
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubPositionCustomer(@RequestBody MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return Result.ok(mdmCustomerMsgService.findCurrentAndSubPositionCustomer(mdmPositionCustomerSearchReqVo));
    }

    @ApiOperation(value = "查询指定职位的客户分页列表及联系人")
    @PostMapping("/listAndContactPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> listAndContactPage(@RequestBody MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        PageResult<MdmCustomerContactPageRespVo> result = mdmCustomerMsgService.listAndContactPage(mdmCustomerContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation("根据客户编码查询对接人列表")
    @PostMapping("/dockingList")
    public Result<List<MdmCustomerDockingRespVo>> dockingList(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        return Result.ok(mdmCustomerMsgService.dockingList(mdmCustomerDockingReqVo));
    }

    @ApiOperation(value = "根据编码集合查询客户分页列表及主联系人")
    @PostMapping("/customerContactPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> customerContactPage(@RequestBody MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        PageResult<MdmCustomerContactPageRespVo> result = mdmCustomerMsgService.customerContactPage(mdmCustomerContactPageReqVo);
        return Result.ok(result);
    }


    @ApiOperation(value = "sfa-根据编码集合查询客户分页列表及主联系人")
    @CrmDictMethod
    @PostMapping("sfaFindCustomerContactPage")
    public Result<List<MdmCustomerContactPageRespVo>> sfaFindCustomerContactPage(@RequestBody List<String> customerCodes) {
        return Result.ok(mdmCustomerMsgService.sfaFindCustomerContactPage(customerCodes));
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "mdmCustomerMsgReqVos", value = "客户集合", required = true, paramType = "body")
    })
    @ApiOperation("根据客户编码集合修改经纬度")
    @PostMapping("/updateCoordinate")
    public Result<Object> updateCoordinate(@RequestBody List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        mdmCustomerMsgService.updateCoordinate(mdmCustomerMsgReqVos);
        return Result.ok();
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation("冻结")
    @PostMapping("/frozen")
    public Result<Object> frozen(@RequestBody List<String> ids) {
        mdmCustomerMsgService.frozen(ids);
        return Result.ok();
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation("解冻")
    @PostMapping("/thaw")
    public Result<Object> thaw(@RequestBody List<String> ids) {
        mdmCustomerMsgService.thaw(ids);
        return Result.ok();
    }

    @ApiOperation("查询当前及下级职位关联的客户数量")
    @GetMapping("/findPositionRelationCustomerCount")
    public Result<Integer> findPositionRelationCustomerCount(@RequestParam("positionCode") String positionCode) {
        Integer count = mdmCustomerMsgService.findPositionRelationCustomerCount(positionCode);
        return Result.ok(count);
    }

    @ApiOperation("查询当前职位关联的客户数量")
    @GetMapping("/findCurrentPositionRelationCustomerCount")
    public Result<Integer> findCurrentPositionRelationCustomerCount(@RequestParam("positionCode") String positionCode) {
        Integer count = mdmCustomerMsgService.findCurrentPositionRelationCustomerCount(positionCode);
        return Result.ok(count);
    }

    @ApiOperation(value = "条件查询客户主联系人及距离分页列表")
    @PostMapping("/distanceContactPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactPage(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        mdmCustomerDistanceContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        PageResult<MdmCustomerContactPageRespVo> result = mdmCustomerMsgService.distanceContactPage(mdmCustomerDistanceContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "条件查询客户主联系人及距离分页列表（可以查到非审批通过的）")
    @PostMapping("/distanceContactNoBpmFilterPage")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactNoBpmFilterPage(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        PageResult<MdmCustomerContactPageRespVo> result = mdmCustomerMsgService.distanceContactPage(mdmCustomerDistanceContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation("根据当前组织编码集合查询当前及下级组织对应的客户")
    @PostMapping("/findSubCustomerList")
    public Result<List<MdmCustomerMsgRespVo>> findSubCustomerList(@RequestBody MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo) {
        return Result.ok(mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo));
    }


    @ApiOperation("小程序APP报表客户与拜访(默认今天)")
    @PostMapping("/fingCustomerAndVisit")
    public Result<MdmCustomerCountRespVo> fingCustomerAndVisit(@RequestBody MdmCustomerCountReqVo mdmCustomerCountReqVo) {
        return Result.ok(mdmCustomerMsgService.fingCustomerAndVisit(mdmCustomerCountReqVo));
    }

    @ApiOperation(value = "提交工作流审批")
    @PostMapping("/submit")
    public Result submit(@RequestBody MdmCustomerMsgReqVo reqVo) {
        mdmCustomerMsgService.submit(reqVo);
        return Result.ok("提交审批成功");
    }

    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/activityCallBack")
    public Result callback(@RequestBody ActivitiCallBackVo reqVo) {
        mdmCustomerMsgService.callback(reqVo);
        return Result.ok("活动审批回调成功");
    }

    @ApiOperation(value = "状态审批，提交")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/statusApprovalSubmit")
    public Result<Object> statusApprovalSubmit(@RequestBody List<String> ids) {
        mdmCustomerMsgService.statusApprovalSubmit(ids);
        return Result.ok();
    }

    @ApiOperation(value = "状态审批，驳回")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/statusApprovalReject")
    public Result<Object> statusApprovalReject(@RequestBody List<String> ids) {
        mdmCustomerMsgService.statusApprovalReject(ids);
        return Result.ok();
    }

    @ApiOperation(value = "状态审批，审批通过")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/statusApprovalAgree")
    public Result<Object> statusApprovalAgree(@RequestBody List<String> ids) {
        mdmCustomerMsgService.statusApprovalAgree(ids);
        return Result.ok();
    }

    @ApiOperation(value = "根据客户组织编码集合查询客户组织下的经销商")
    @PostMapping("/findCustomerByCustomerOrgCodeList")
    public Result<List<MdmCustomerMsgRespVo>> findCustomerByCustomerOrgCodeList(@RequestBody List<String> customerOrgCodeList) {
        return Result.ok(mdmCustomerMsgService.findCustomerByCustomerOrgCodeList(customerOrgCodeList));
    }

    @ApiOperation(value = "根据客户编码集合查询客户信息")
    @PostMapping("/queryByCustomerCodeList")
    @CrmDictMethod
    public Result<List<MdmCustomerMsgRespVo>> queryByCustomerCodeList( @RequestBody List<String> customerCodeList) {
        List<MdmCustomerMsgRespVo> modelList = mdmCustomerMsgService.queryByCustomerCodeList(customerCodeList);
        return Result.ok(modelList);
    }


}
