package com.biz.crm.customer.controller;

import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerROrgReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 客户所属组织控制器
 *
 * @author zxw
 * @date 2020-12-23 14:09
 **/
@RestController
@RequestMapping("/mdmCustomerRelationOrgController")
public class MdmCustomerRelationOrgController {

    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;

    @ApiOperation("根据客户编码查询组织编码集合")
    @PostMapping("/findOrgCodeListByCustomerCode")
    public Result<List<String>> findOrgCodeListByCustomerCode(@RequestBody MdmCustomerROrgReqVo mdmCustomerROrgReqVo) {
        return Result.ok(mdmCustomerROrgService.findOrgCodeByCustomerCode(mdmCustomerROrgReqVo.getCustomerCode()));
    }
}
