package com.biz.crm.customer.event.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.customer.event.CustomerChangeEvent;
import com.biz.crm.customer.handler.CustomerChangeHandler;
import com.biz.crm.nebular.mdm.customer.CustomerChangeHandlerReqVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

import java.util.List;

/**
 * @author sunx
 * @date 2021/9/9
 */
@Component
@Slf4j
public class CustomerEventListener {
    /**
     * 终端信息变更实现
     */
    @Autowired(required = false)
    private List<CustomerChangeHandler> customerChangeHandlers;

    @Async
    @TransactionalEventListener(phase = TransactionPhase.AFTER_COMMIT)
    public void onCustomerChangeEvent(CustomerChangeEvent event) {
        CustomerChangeHandlerReqVo vo = (CustomerChangeHandlerReqVo) event.getSource();
        log.info("客户信息改变事件监听:{}", JSON.toJSONString(vo));
        if (CollectionUtils.isNotEmpty(customerChangeHandlers)) {
            customerChangeHandlers.forEach(a -> a.handler(vo));
        }
        log.info("客户信息改变事件监听处理完成");
    }
}
