package com.biz.crm.customer.manager;

import com.biz.crm.common.BaseBuilder;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 客户信息构造器
 *
 * @author zxw
 * @date 2020-09-04 21:32
 **/
public class MdmCustomerMsgBuilder extends BaseBuilder<MdmCustomerMsgReqVo> {

    private MdmCustomerEntity mdmCustomerMsgEntity;

    private boolean isSave;

    private MdmCustomerMsgService mdmCustomerMsgService;

    private MdmUserService mdmUserService;


    public static MdmCustomerMsgBuilder builder(boolean isSave, MdmCustomerMsgService mdmCustomerMsgService, MdmUserService mdmUserService) {
        MdmCustomerMsgBuilder builder = new MdmCustomerMsgBuilder();
        builder.isSave=isSave;
        builder.mdmCustomerMsgService = mdmCustomerMsgService;
        builder.mdmUserService = mdmUserService;
        return builder;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> valid() {
        Assert.hasText(t.getCustomerName(), "客户信息名称不能为空");
//        Assert.hasText(t.getOrgCode(), "所属组织不能为空");
        Assert.isTrue(isSave || !StringUtils.isEmpty(t.getId()), "数据主键不能为空");
//        Assert.isTrue(isSave || !StringUtils.isEmpty(t.getCustomerCode()), "客户编码不能为空");
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> convert() {
        if (isSave) {
            if (StringUtils.isEmpty(t.getCustomerCode())) {
                t.setCustomerCode(CodeUtil.generateCode(CodeRuleEnum.MDM_CUSTOMER.getCode()));
            }else{
                Integer count = mdmCustomerMsgService.lambdaQuery()
                        .eq(MdmCustomerEntity::getCustomerCode, t.getCustomerCode())
                        .select(MdmCustomerEntity::getId)
                        .count();
                Assert.isTrue(count == null || count < 1, "客户编码已存在");
            }
            t.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        }else{
            long count = mdmCustomerMsgService.lambdaQuery()
                    .eq(MdmCustomerEntity::getCustomerCode, t.getCustomerCode())
                    .select(MdmCustomerEntity::getId)
                    .list().stream().filter(x -> !t.getId().equals(x.getId()))
                    .count();
            Assert.isTrue(count < 1, "客户编码已存在");
        }
        mdmCustomerMsgEntity = CrmBeanUtil.copy(t, MdmCustomerEntity.class);

        if (StringUtils.isNotEmpty(t.getProvinceCode()) || StringUtils.isNotEmpty(t.getCityCode()) || StringUtils.isNotEmpty(t.getDistrictCode())) {
            Set<String> regionCodeSet = new HashSet<>(16);
            if (StringUtils.isNotEmpty(t.getProvinceCode())) {
                regionCodeSet.add(t.getProvinceCode());
            }
            if (StringUtils.isNotEmpty(t.getCityCode())) {
                regionCodeSet.add(t.getCityCode());
            }
            if (StringUtils.isNotEmpty(t.getDistrictCode())) {
                regionCodeSet.add(t.getDistrictCode());
            }
            MdmRegionService mdmRegionService = SpringApplicationContextUtil.getApplicationContext().getBean(MdmRegionService.class);
            final Map<String, String> regionCodeNameMap = mdmRegionService.lambdaQuery()
                    .in(MdmRegionEntity::getRegionCode, regionCodeSet)
                    .select(MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName)
                    .list()
                    .stream().collect(Collectors.toMap(MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName));
            mdmCustomerMsgEntity.setProvinceName(regionCodeNameMap.get(mdmCustomerMsgEntity.getProvinceCode()));
            mdmCustomerMsgEntity.setCityName(regionCodeNameMap.get(mdmCustomerMsgEntity.getCityCode()));
            mdmCustomerMsgEntity.setDistrictName(regionCodeNameMap.get(mdmCustomerMsgEntity.getDistrictCode()));
        }

        if (StringUtils.isEmpty(mdmCustomerMsgEntity.getActApproveStatus())) {
            mdmCustomerMsgEntity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            mdmCustomerMsgEntity.setApprovalType(ApprovalType.NULL.getValue());
        }
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> after() {
        mdmCustomerMsgService.setUpCollateral(t);
        if (MdmBpmStatusEnum.PASS.getValue().equals(mdmCustomerMsgEntity.getActApproveStatus())) {
            mdmCustomerMsgService.sendCustomerInsertMsg(t);
            mdmCustomerMsgService.sendCustomerChangeMsg(Collections.singletonList(t.getCustomerCode()));
            mdmCustomerMsgService.sendAchievementMsg(t.getCustomerCode(), t.getFromType());
        }
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> persistence() {
        if (isSave) {
            String id = UUID.randomUUID().toString();
            mdmCustomerMsgEntity.setId(id);
            t.setId(id);
            mdmCustomerMsgService.save(mdmCustomerMsgEntity);
        }else{
            mdmCustomerMsgService.updateById(mdmCustomerMsgEntity);
        }
        return this;
    }
}
