package com.biz.crm.customer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.customer.model.MdmCustomerAddressEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 客户信息：收货地址
 * 
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
public interface MdmCustomerAddressMapper extends BaseMapper<MdmCustomerAddressEntity> {
    /**
     * 列表
     * @param page page
     * @param mdmCustomerAddressReqVo vo
     * @return list
     */
    List<MdmCustomerAddressRespVo> findList(Page<MdmCustomerAddressRespVo> page, @Param("vo") MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 根据id查询详情
     * @param id id
     * @return vo
     */
    MdmCustomerAddressRespVo query(@Param("id") String id);
}
