package com.biz.crm.customer.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.provider.MdmCustomerProvider;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
public interface MdmCustomerMsgMapper extends BaseMapper<MdmCustomerEntity> {

    /**
     * 客户信息分页
     *
     * @param page                page
     * @param mdmCustomerMsgReqVo wrapper
     * @return list
     */
    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )"
    )
    List<MdmCustomerMsgRespVo> findList(Page<MdmCustomerMsgRespVo> page, @Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 客户信息分页(provider)
     *
     * @param page                page
     * @param mdmCustomerMsgReqVo wrapper
     * @return list
     */
    @SelectProvider(type = MdmCustomerProvider.class, method = "findListMsg")
    List<MdmCustomerMsgRespVo> findListMsg(Page<MdmCustomerMsgRespVo> page,
                                           @Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    //产品销售报表
    List<CustomerProductRespVo> findPageList(Page<CustomerProductRespVo> page,@Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    //客户销售报表
    List<CustomerSaleRespVo> findCustomerPageList(Page<CustomerSaleRespVo> page,@Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 查询未关联任何用户客户
     *
     * @param page    page
     * @param wrapper wrapper
     * @return list
     */
    List<MdmUserRelationCustomerPageRespVo> findUnRelationAnyUser(Page<MdmUserRelationCustomerPageRespVo> page, @Param("ew") QueryWrapper<MdmUserRelationCustomerPageRespVo> wrapper);

    /**
     * 查询用户所有客户编码
     *
     * @param userName 用户帐号
     * @return list
     */
    List<String> findAllCustomerApprovedCodeByUser(@Param("userName") String userName, @Param("actApproveStatus") String actApproveStatus);

    @Deprecated
    List<String> findAllCustomerCodeByUser(@Param("userName") String userName);

    /**
     * 客户信息查询
     *
     * @param mdmCustomerMsgReqVo privilege
     * @return MdmCustomerMsgRespVo
     */
    MdmCustomerMsgRespVo query(@Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 客户通用条件查询
     *
     * @param mdmCustomerOrgSearchReqVo 条件
     * @return 客户集合
     */
    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )"
    )
    List<MdmCustomerMsgRespVo> listCondition(@Param("vo") MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo);

    /**
     * 客户信息通用分页查询
     *
     * @param page    page
     * @param wrapper wrapper
     * @return list
     */
    List<MdmCustomerMsgRespVo> pageCondition(Page<MdmCustomerMsgRespVo> page, @Param("ew") QueryWrapper<MdmCustomerMsgRespVo> wrapper);

    /**
     * 根据职位id或职位编码查询
     *
     * @param mdmPositionCustomerSearchReqVo privilege
     * @return list
     */
    List<MdmCustomerMsgRespVo> findPositionCustomerList(@Param("vo") MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo);

    /**
     * 客户信息主联系人分页查询
     *
     * @param page                        page
     * @param mdmCustomerContactPageReqVo vo
     * @return page
     */
    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )",
            custCode = "a.customer_code"
    )
    List<MdmCustomerContactPageRespVo> listAndContactPage(Page<MdmCustomerMsgRespVo> page, @Param("vo") MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo);

    /**
     * 商品下拉框
     *
     * @param reqVo
     * @param includeList 只查询这些编码
     * @param excludeList 排除这些编码
     * @return
     */
    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )"
    )
    List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(Page<MdmCustomerMsgSelectRespVo> page, @Param("vo") MdmCustomerMsgSelectReqVo reqVo, @Param("includeList") List<String> includeList, @Param("excludeList") List<String> excludeList);

    /**
     * 用户管理页面查询客户下拉框
     *
     * @param page
     * @param mdmCustomerMsgReqVo
     * @return
     */
    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )"
    )
    List<MdmCustomerMsgSelectRespVo> findCustomerNotRelateUserSelectList(Page<MdmCustomerMsgSelectRespVo> page, @Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 条件查询客户主联系人及距离分页列表
     *
     * @param page                                page
     * @param mdmCustomerDistanceContactPageReqVo vo
     * @return list
     */
    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )",
            custCode = "a.customer_code"
    )
    List<MdmCustomerContactPageRespVo> distanceContactPage(Page<MdmCustomerContactPageRespVo> page, @Param("vo") MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo);

    /**
     * 根据组织编码集合查询客户
     *
     * @param mdmCustomerOrgSearchReqVo 组织编码集合
     * @return list
     */
    List<MdmCustomerMsgRespVo> findListByOrgCodeList(Page<MdmCustomerMsgRespVo> page, @Param("vo") MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo);

    /**
     * 根据组织编码集合查询当前及下级组织对应的客户
     *
     * @param mdmCustomerOrgSearchReqVo vo
     * @return list
     */
    List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo);


    /**
     * 根据职位编码查询对接客户数
     * @param posCode
     * @param dateTime
     * @return
     */
    @Deprecated
    BigDecimal fingCustomerApprovedCount(@Param("posCode") String posCode,@Param("dateTime") String dateTime,@Param("actApproveStatus") String actApproveStatus);

    @Deprecated
    BigDecimal fingCustomerCount(@Param("posCode") String posCode,@Param("dateTime") String dateTime);

    @SqlPrivilege(
            inOrgSql = "a.customer_code in(select customer_code from mdm_customer_r_org where org_code in )",
            inPositionSql = "a.customer_code in(select customer_code from mdm_customer_supply where position_code in )"
    )
    List<MdmCustomerMsgSelectRespVo> list(@Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo, Page<MdmCustomerMsgSelectRespVo> page);

    List<String> findByOrgCodeList(@Param("vo") List<String> list);

    /**
     * 根据职位编码查询对接客户数
     *
     * @param positionCode 职位编码
     * @param dateTime
     * @return
     */
    Long countCustomerByPosition(@Param("positionCode") String positionCode, @Param("dateTime") String dateTime, @Param("actApproveStatus") String actApproveStatus);

    /**
     * 根据职位编码查询客户编码集合
     * @param list list
     * @return list
     */
    List<String> findByPositionCodeList(@Param("vo") List<String> list);

    List<MdmTerminalStatisticianTypeVo> statisticalType(@Param("vo") MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 客户省统计
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictStatisticianRespVo> statisticalProvince(@Param("vo") MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 客户市统计
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictStatisticianRespVo> statisticalCity(@Param("vo") MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    List<MdmAmapDistrictStatisticianRespVo> statisticalDistrict(@Param("vo") MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);
}
