package com.biz.crm.customer.mapper;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 职位与用户关联表
 *
 * @author zxw
 * @date 2020-10-10 13:59:04
 */
public interface MdmCustomerSupplyMapper extends BaseMapper<MdmCustomerSupplyEntity> {

    /**
     * 查询未关联当前用户客户
     *
     * @param page 分页
     * @param wrapper 条件
     * @return 客户集合
     */
    List<MdmUserRelationCustomerPageRespVo> findUnRelationCurrentUser(Page<MdmUserRelationCustomerPageRespVo> page,@Param("ew") QueryWrapper<MdmUserRelationCustomerPageRespVo> wrapper);

    /**
     * 根据客户编码查询对接人列表
     * @param mdmCustomerDockingReqVo vo
     * @return list
     */
    List<MdmCustomerDockingRespVo> findDockingListByCustomerCode(@Param("vo") MdmCustomerDockingReqVo mdmCustomerDockingReqVo);
}
