package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerAddressEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;

import java.util.List;

/**
 * 客户信息：收货地址接口
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
public interface MdmCustomerAddressService extends IService<MdmCustomerAddressEntity> {

    /**
     * 列表
     *
     * @param mdmCustomerAddressReqVo
     * @return PageResult<MdmCustomerAddressRespVo>
     */
    PageResult<MdmCustomerAddressRespVo> findList(MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 查询
     *
     * @param id id
     * @return MdmCustomerAddressRespVo
     */
    MdmCustomerAddressRespVo query(String id);

    /**
     * 新增
     *
     * @param mdmCustomerAddressReqVo
     * @return
     */
    void save(MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 更新
     *
     * @param mdmCustomerAddressReqVo
     * @return
     */
    void update(MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 删除
     *
     * @param ids id集合
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 条件列表查询
     * @param mdmCustomerAddressConditionReqVo vo
     * @return list
     */
    List<MdmCustomerAddressRespVo> listCondition(MdmCustomerAddressConditionReqVo mdmCustomerAddressConditionReqVo);
}

