package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.customer.model.MdmCustomerSaleAreaEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerSaleAreaRespVo;

import java.util.List;

/**
 * 客户信息销售区域接口
 *
 * @author zxw
 * @date 2020-11-16 15:50:20
 */
public interface MdmCustomerSaleAreaService extends IService<MdmCustomerSaleAreaEntity> {

    /**
     * 根据客户编码删除
     * @param customerCode 客户编码
     */
    void remove(String customerCode);

    /**
     * 添加
     * @param list list
     */
    void add(List<MdmCustomerSaleAreaEntity> list);

    /**
     * 根据客户编码查询
     * @param mdmCustomerSaleAreaReqVo privilege
     * @return list
     */
    List<MdmCustomerSaleAreaRespVo> listCondition(MdmCustomerSaleAreaReqVo mdmCustomerSaleAreaReqVo);

    /**
     * 更新客户与销售区域的关系
     * @param mdmCustomerSaleAreaReqVos 销售区域列表
     * @param customerCode 客户编码
     */
    void setUpArea(List<MdmCustomerSaleAreaReqVo> mdmCustomerSaleAreaReqVos, String customerCode);
}

