package com.biz.crm.customer.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;

import java.util.List;

/**
 * 职位与用户关联表接口
 *
 * @author zxw
 * @date 2020-10-10 13:59:04
 */
public interface MdmCustomerSupplyService extends IService<MdmCustomerSupplyEntity> {

    /**
     * 根据职位编码集合查询客户集合
     *
     * @param positionCodeList 职位编码集合
     * @return list
     */
    List<String> findCustomerCodeByPosition(List<String> positionCodeList);

    /**
     * 添加客户和职位关联
     *
     * @param customerCode
     * @param positionCode
     */
    void addRelation(String customerCode, String positionCode);

    void addRelation(String customerCode, String positionCode, String orgCode);

    /**
     * 替换关联的职位
     *
     * @param ids
     * @param positionCode
     */
    void replacePosition(List<String> ids, String positionCode);

    void replacePosition(List<String> ids, String positionCode, String orgCode);

    /**
     * 移除关联关系
     *
     * @param ids
     */
    void removeRelations(List<String> ids);

    /**
     * 移除客户关联的全部职位
     *
     * @param customerCode
     */
    void removeByCustomer(String customerCode);

    /**
     * 批量移除客户关联的全部职位
     *
     * @param customerCodes
     */
    void removeByCustomers(List<String> customerCodes);

    /**
     * 移除职位关联的全部客户
     *
     * @param positionCode
     */
    void removeByPosition(String positionCode);

    /**
     * 批量移除职位关联的全部客户
     *
     * @param positionCodes
     */
    void removeByPositions(List<String> positionCodes);


    /**
     * 维护客户对接人
     *
     * @param mdmCustomerMsgReqVo vo
     */
    void setUpDocking(MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 根据客户编码集合批量删除对接人及供货关系
     * @param customerCodeList 客户编码集合
     */
    void removeByCustomerCodeList(List<String> customerCodeList);

    /**
     * 根据客户编码查询对接人列表
     *
     * @param mdmCustomerDockingReqVo vo
     * @return list
     */
    List<MdmCustomerDockingRespVo> findDockingListByCustomerCode(MdmCustomerDockingReqVo mdmCustomerDockingReqVo);

    List<MdmCustomerDockingRespVo> findCustomerSupplyByCustomerCodeList(List<String> customerCodeList);
}

