package com.biz.crm.customer.service;


import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.customer.*;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
public interface MdmCustomerTerminalService {


    /**
     * 解除上级客户
     *
     * @param mdmCustomerCorrelatedTerminalReqVo
     */
    void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo);

    /**
     * 替换上级客户
     *
     * @param mdmCustomerCorrelatedTerminalReplaceReqVo
     */
    void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo);


    /**
     * 已关联客户的终端分页
     *
     * @param mdmCustomerTerminalReqVo vo
     * @return page
     */
    PageResult<MdmCustomerTerminalRespVo> correlatedCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 未关联任何客户的终端分页
     *
     * @param mdmCustomerTerminalReqVo vo
     * @return page
     */
    PageResult<MdmCustomerTerminalRespVo> unCorrelatedAnyCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 未关联当前客户的终端分页
     *
     * @param mdmCustomerTerminalReqVo vo
     * @return page
     */
    PageResult<MdmCustomerTerminalRespVo> unCorrelatedCurrentCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 新增客户与终端关联
     * @param mdmCustomerCorrelatedTerminalReqVo vo
     */
    void correlatedTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo);

    /**
     * 模糊查询终端或者客户
     *
     * @param reqVo
     * @return
     */
    List<MdmCustomerTerminalFuzzyQueryVo> findCustomerTerminalFuzzyList(MdmCustomerTerminalFuzzyQueryVo reqVo);
}

