package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerAddressMapper;
import com.biz.crm.customer.model.MdmCustomerAddressEntity;
import com.biz.crm.customer.service.MdmCustomerAddressService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 客户信息：收货地址接口实现
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmCustomerAddressServiceExpandImpl")
public class MdmCustomerAddressServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmCustomerAddressMapper, MdmCustomerAddressEntity> implements MdmCustomerAddressService {

    @Resource
    private MdmCustomerAddressMapper mdmCustomerAddressMapper;

    @Override
    public PageResult<MdmCustomerAddressRespVo> findList(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Page<MdmCustomerAddressRespVo> page = new Page<>(mdmCustomerAddressReqVo.getPageNum(), mdmCustomerAddressReqVo.getPageSize());
        List<MdmCustomerAddressRespVo> list = mdmCustomerAddressMapper.findList(page, mdmCustomerAddressReqVo);
        return PageResult.<MdmCustomerAddressRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    @Override
    public MdmCustomerAddressRespVo query(String id) {
        return mdmCustomerAddressMapper.query(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Assert.hasText(mdmCustomerAddressReqVo.getCustomerCode(), "客户编码不能为空");
        mdmCustomerAddressReqVo.setId(null);
        MdmCustomerAddressEntity entity = CrmBeanUtil.copy(mdmCustomerAddressReqVo, MdmCustomerAddressEntity.class);
        String defaultAddress = mdmCustomerAddressReqVo.getDefaultAddress();
        if (!StringUtils.isEmpty(defaultAddress) && YesNoEnum.yesNoEnum.ONE.getValue().equals(defaultAddress)) {
            this.lambdaUpdate()
                    .eq(MdmCustomerAddressEntity::getCustomerCode, mdmCustomerAddressReqVo.getCustomerCode())
                    .eq(MdmCustomerAddressEntity::getDefaultAddress, YesNoEnum.yesNoEnum.ONE.getValue())
                    .set(MdmCustomerAddressEntity::getDefaultAddress, YesNoEnum.yesNoEnum.ZERO.getValue())
                    .update();
        }
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Assert.hasText(mdmCustomerAddressReqVo.getCustomerCode(), "客户编码不能为空");
        Assert.hasText(mdmCustomerAddressReqVo.getId(), "数据主键不能为空");

//        Assert.hasText(mdmCustomerAddressReqVo.getDistrictCode(), "送达方编码不能为空");
//        Integer count = this.lambdaQuery()
//                .eq(MdmCustomerAddressEntity::getId, mdmCustomerAddressReqVo.getId())
//                .count();
//        Assert.isTrue(count != null && count > 0, "客户地址不存在");
//        Integer count1 = this.lambdaQuery()
//                .ne(MdmCustomerAddressEntity::getId, mdmCustomerAddressReqVo.getId())
//                .eq(MdmCustomerAddressEntity::getCustomerCode, mdmCustomerAddressReqVo.getCustomerCode())
//                .eq(MdmCustomerAddressEntity::getDistrictCode, mdmCustomerAddressReqVo.getDistrictCode())
//                .count();
//        Assert.isTrue(count1 == null || count1 < 1, "送达方编码已存在");
        String defaultAddress = mdmCustomerAddressReqVo.getDefaultAddress();
        if (!StringUtils.isEmpty(defaultAddress) && YesNoEnum.yesNoEnum.ONE.getValue().equals(defaultAddress)) {
            this.lambdaUpdate()
                    .eq(MdmCustomerAddressEntity::getCustomerCode, mdmCustomerAddressReqVo.getCustomerCode())
                    .eq(MdmCustomerAddressEntity::getDefaultAddress, YesNoEnum.yesNoEnum.ONE.getValue())
                    .set(MdmCustomerAddressEntity::getDefaultAddress, YesNoEnum.yesNoEnum.ZERO.getValue())
                    .update();
        }
        this.updateById(CrmBeanUtil.copy(mdmCustomerAddressReqVo, MdmCustomerAddressEntity.class));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, "id集合不能为空");
        this.removeByIds(ids);
    }

    @Override
    public List<MdmCustomerAddressRespVo> listCondition(MdmCustomerAddressConditionReqVo mdmCustomerAddressConditionReqVo) {
        Boolean withinEffectiveTime = mdmCustomerAddressConditionReqVo.getWithinEffectiveTime();
        String format = LocalDate.now().format(DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DAY_PATTERN));
        List<MdmCustomerAddressEntity> list = this.lambdaQuery()
                .eq(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getCustomerCode()), MdmCustomerAddressEntity::getCustomerCode, mdmCustomerAddressConditionReqVo.getCustomerCode())
                .eq(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getCityCode()), MdmCustomerAddressEntity::getCityCode, mdmCustomerAddressConditionReqVo.getCityCode())
                .eq(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getDistrictCode()), MdmCustomerAddressEntity::getDistrictCode, mdmCustomerAddressConditionReqVo.getDistrictCode())
                .eq(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getProvinceCode()), MdmCustomerAddressEntity::getProvinceCode, mdmCustomerAddressConditionReqVo.getProvinceCode())
                .eq(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getDestinationCode()), MdmCustomerAddressEntity::getDestinationCode, mdmCustomerAddressConditionReqVo.getDestinationCode())
                .like(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getDestinationName()), MdmCustomerAddressEntity::getDestinationName, mdmCustomerAddressConditionReqVo.getDestinationName())
                .eq(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getDefaultAddress()), MdmCustomerAddressEntity::getDefaultAddress, mdmCustomerAddressConditionReqVo.getDefaultAddress())
                .like(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getContactName()), MdmCustomerAddressEntity::getContactName, mdmCustomerAddressConditionReqVo.getContactName())
                .like(!StringUtils.isEmpty(mdmCustomerAddressConditionReqVo.getContactPhone()), MdmCustomerAddressEntity::getContactPhone, mdmCustomerAddressConditionReqVo.getContactPhone())
                .le(withinEffectiveTime != null && withinEffectiveTime, MdmCustomerAddressEntity::getStartTime, format)
                .ge(withinEffectiveTime != null && withinEffectiveTime, MdmCustomerAddressEntity::getEndTime, format)
                .list();
        return CrmBeanUtil.copyList(list, MdmCustomerAddressRespVo.class);
    }



}
