package com.biz.crm.customer.service.impl;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerBillMapper;
import com.biz.crm.customer.model.MdmCustomerBillEntity;
import com.biz.crm.customer.service.MdmCustomerBillService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerBillReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerBillRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 客户开票信息接口实现
 *
 * @author zxw
 * @date 2021-01-24 22:48:12
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmCustomerBillServiceExpandImpl")
public class MdmCustomerBillServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmCustomerBillMapper, MdmCustomerBillEntity> implements MdmCustomerBillService {

    @Override
    public void setUp(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        if (!StringUtils.isEmpty(customerCode)) {
            this.lambdaUpdate()
                    .eq(MdmCustomerBillEntity::getCustomerCode, customerCode)
                    .remove();
            List<MdmCustomerBillReqVo> mdmCustomerBillVos = mdmCustomerMsgReqVo.getMdmCustomerBillVos();
            if (CollectionUtil.listNotEmptyNotSizeZero(mdmCustomerBillVos)) {
                List<MdmCustomerBillReqVo> collect = mdmCustomerBillVos.stream().filter(x -> x != null && !StringUtils.isEmpty(x.getBillCompany())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    long count = collect.stream()
                            .filter(x -> !StringUtils.isEmpty(x.getBillMain()))
                            .filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getBillMain()))
                            .count();
                    if (count != 1) {
                        collect = collect.stream().peek(x -> x.setBillMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
                        collect.get(0).setBillMain(YesNoEnum.yesNoEnum.ONE.getValue());
                    }
                    collect = collect.stream().peek(x -> x.setCustomerCode(customerCode)).collect(Collectors.toList());
                    this.saveBatch(CrmBeanUtil.copyList(collect, MdmCustomerBillEntity.class));
                }
            }
        }
    }

    @Override
    public List<MdmCustomerBillRespVo> listCondition(String customerCode) {
        if(StringUtils.isEmpty(customerCode)){
            return new ArrayList<>();
        }
        List<MdmCustomerBillEntity> list = this.lambdaQuery()
                .eq(MdmCustomerBillEntity::getCustomerCode, customerCode)
                .list();
        return CrmBeanUtil.copyList(list, MdmCustomerBillRespVo.class);
    }
}
