package com.biz.crm.customermaterial.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customermaterial.service.IMdmCustomerMaterialService;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 客户物料
 *
 * @author huang.long
 * @date 2020-09-03 10:37:31
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerMaterialController")
@Api(tags = "客户物料")
@CrmGlobalLog
public class MdmCustomerMaterialController {
    @Resource
    private IMdmCustomerMaterialService mdmCustomerMaterialService;

    @ApiOperation(value = "分页查询")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMaterialRespVo>> list(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        PageResult<MdmCustomerMaterialRespVo> result=mdmCustomerMaterialService.findList(mdmCustomerMaterialReqVo);
        return Result.ok(result);
    }

    @ApiImplicitParams({
         @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    public Result<MdmCustomerMaterialRespVo> query(@RequestParam String id) {
        MdmCustomerMaterialRespVo respVo=mdmCustomerMaterialService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        mdmCustomerMaterialService.save(mdmCustomerMaterialReqVo);
        return Result.ok("新增成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        mdmCustomerMaterialService.update(mdmCustomerMaterialReqVo);
        return Result.ok("更新成功");
    }

    /**
     * 删除
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo = new MdmCustomerMaterialReqVo();
        mdmCustomerMaterialReqVo.setIds(ids);
        mdmCustomerMaterialService.deleteBatch(mdmCustomerMaterialReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo = new MdmCustomerMaterialReqVo();
        mdmCustomerMaterialReqVo.setIds(ids);
        mdmCustomerMaterialService.enableBatch(mdmCustomerMaterialReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo = new MdmCustomerMaterialReqVo();
        mdmCustomerMaterialReqVo.setIds(ids);
        mdmCustomerMaterialService.disableBatch(mdmCustomerMaterialReqVo);
        return Result.ok("禁用成功");
    }
}
