package com.biz.crm.customermaterial.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.customermaterial.model.MdmCustomerMaterialEntity;
import com.biz.crm.customermaterial.provider.MdmCustomerMaterialProvider;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 客户物料
 * 
 * @author huang.long
 * @date 2020-09-02 22:09:56
 */
public interface MdmCustomerMaterialMapper extends BaseMapper<MdmCustomerMaterialEntity> {
    /**
     * 列表
     * @param page
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    @SqlPrivilege(
        extPosSql = "select 1 from mdm_position_user pu where pu.user_name=a.create_code and pu.position_code in",
        extOrgSql = "select 1 from mdm_position_user pu left join mdm_position p on pu.position_code=p.position_code where pu.user_name=a.create_code and p.org_code in"
    )
    List<MdmCustomerMaterialRespVo> findList(Page<MdmCustomerMaterialRespVo> page, @Param("vo") MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);

    /**
     * 列表
     * @param page
     * @param mdmCustomerMaterialReqVo
     * @return
     */
    @SelectProvider(type = MdmCustomerMaterialProvider.class,method = "findListProvider")
    List<MdmCustomerMaterialRespVo> findListProvider(Page<MdmCustomerMaterialRespVo> page, @Param("vo") MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);



    /**
     * 单个查询
     *
     * @param mdmCustomerMaterialReqVo mdmCustomerMaterialReqVo
     * @return com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo
     **/
    MdmCustomerMaterialRespVo query(@Param("vo") MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo);
}
