package com.biz.crm.dict.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 数据字典扩展字段配置表
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Slf4j
@RestController
@RequestMapping("/mdmdictattrconf")
@Api(tags = "MDM-数据字典-扩展字段配置表")
@CrmGlobalLog
public class MdmDictAttrConfController {

    @Autowired
    private MdmDictAttrConfService mdmDictAttrConfService;

    @ApiImplicitParams({
            @ApiImplicitParam(name = "dictTypeCode", value = "字典类型", required = true, paramType = "query")
    })
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<List<MdmDictAttrConfRespVo>> list(@RequestParam("dictTypeCode") String dictTypeCode) {
        List<MdmDictAttrConfRespVo> list = mdmDictAttrConfService.findList(dictTypeCode);
        return Result.ok(list);
    }

    @ApiOperation(value = "查询扩展字段列表")
    @PostMapping("/findAttrConfList")
    @CrmDictMethod
    public Result<List<MdmDictAttrConfRespVo>> findAttrConfList(@RequestBody MdmDictAttrConfReqVo mdmDictAttrConfReqVo) {
        return Result.ok(mdmDictAttrConfService.findList(mdmDictAttrConfReqVo.getDictTypeCode()));
    }

    @ApiOperation(value = "详情", httpMethod = "GET", notes = "查询详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmDictAttrConfRespVo> query(@RequestParam(value = "id", required = true) String id) {
        return Result.ok(mdmDictAttrConfService.detail(id));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmDictAttrConfReqVo reqVo) {
        mdmDictAttrConfService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmDictAttrConfReqVo reqVo) {
        mdmDictAttrConfService.update(reqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        mdmDictAttrConfService.deleteBatch(ids);
        return Result.ok("删除成功");
    }
}
