package com.biz.crm.dict.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataSelectReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataSelectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 数据字典明细表
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Slf4j
@RestController
@RequestMapping("/mdmdictdata")
@Api(tags = "MDM-数据字典-明细表")
@CrmGlobalLog
public class MdmDictDataController {

    @Autowired
    private MdmDictDataService mdmDictDataService;

    @ApiOperation(value = "（字典维护页面专用）树形列表", notes = "dictTypeCode必传")
    @PostMapping("/treeList")
    public Result<List<MdmDictDataRespVo>> treeList(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        return Result.ok(mdmDictDataService.treeList(mdmDictDataReqVo));
    }

    @ApiOperation(value = "树形列表，从缓存查询", notes = "dictTypeCode必传")
    @PostMapping("/tree")
    public Result<List<DictDataVo>> tree(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        return Result.ok(mdmDictDataService.tree(mdmDictDataReqVo));
    }

    @ApiOperation(value = "查询列表（树形），从缓存查，业务使用", httpMethod = "GET", notes = "dictTypeCode必传")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dictTypeCode", value = "字典类型编码", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/dictTree")
    public Result<List<DictDataVo>> dictTree(@RequestParam("dictTypeCode") String dictTypeCode) {
        return Result.ok(mdmDictDataService.tree(new MdmDictDataReqVo().setDictTypeCode(dictTypeCode)));
    }

    @ApiOperation(value = "批量获取数据字典下拉框", notes = "从缓存查询，返回值没有扩展字段，传字典类型编码集合数组", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "dictTypeCodeList", value = "字典类型编码集合", required = true, paramType = "body")
    })
    @PostMapping("/batchDictSelect")
    public Result<Map<String, List<MdmDictDataSelectRespVo>>> batchDictSelect(@RequestBody List<String> dictTypeCodeList) {
        return Result.ok(mdmDictDataService.batchDictSelect(dictTypeCodeList));
    }

    @ApiOperation(value = "数据字典下拉框", notes = "从缓存查询，dictTypeCode必传，返回值里dictCode:编码；dictValue:值（模糊查询），其余为扩展字段")
    @PostMapping("/list")
    public Result<List<JSONObject>> list(@RequestBody MdmDictDataSelectReqVo reqVo) {
        return Result.ok(mdmDictDataService.list(reqVo));
    }

    @ApiOperation(value = "查询详情", httpMethod = "GET", notes = "只查询数据字典类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/query")
    public Result<MdmDictDataRespVo> query(String id) {
        return Result.ok(mdmDictDataService.query(id));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        mdmDictDataService.save(mdmDictDataReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        mdmDictDataService.update(mdmDictDataReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        mdmDictDataService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

}
