package com.biz.crm.dict.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataSelectReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataSelectRespVo;

import java.util.List;
import java.util.Map;

/**
 * 数据字典明细表接口
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
public interface MdmDictDataService extends IService<MdmDictDataEntity> {

    /**
     * 树形结构
     *
     * @param reqVo
     * @return
     */
    List<MdmDictDataRespVo> treeList(MdmDictDataReqVo reqVo);

    /**
     * 树形结构，从缓存查询
     *
     * @param reqVo
     * @return
     */
    List<DictDataVo> tree(MdmDictDataReqVo reqVo);

    /**
     * 根据字典类型编码查询字典值，从数据库查
     *
     * @param dictTypeCode
     * @return
     */
    List<MdmDictDataRespVo> queryByDictTypeCode(String dictTypeCode);

    /**
     * 批量获取数据字典下拉框
     *
     * @param dictTypeCodeList
     * @return
     */
    Map<String, List<MdmDictDataSelectRespVo>> batchDictSelect(List<String> dictTypeCodeList);

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    List<JSONObject> list(MdmDictDataSelectReqVo reqVo);

    /**
     * 查询详情
     *
     * @return MdmDictDataRespVo
     */
    MdmDictDataRespVo query(String id);

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmDictDataReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    void update(MdmDictDataReqVo reqVo);

    /**
     * 删除
     *
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 根据字典类型删除
     */
    void deleteByDictTypeCode(String dictTypeCode);

    /**
     * 移除明细表指定扩展字段的值
     *
     * @param dictTypeCode 字典类型编码
     * @param extList      扩展字段
     */
    void deleteExtFieldVal(String dictTypeCode, List<String> extList);

    /**
     * 获取字典值的map，从数据库查询
     *
     * @param dictTypeCode
     * @return
     */
    Map<String, String> getDictDataMap(String dictTypeCode);

    /**
     * 获取数据字典值详情map，总数据库查询
     *
     * @param dictTypeCode
     * @return
     */
    Map<String, DictDataVo> getDictDataDetailMap(String dictTypeCode);
}

