package com.biz.crm.dict.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.nebular.mdm.dict.req.MdmDictTypeReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictTypeRespVo;
import com.biz.crm.nebular.mdm.sync.MdmDictEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardDictReqVo;

import java.util.List;

/**
 * 数据字典类型表接口
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
public interface MdmDictTypeService extends IService<MdmDictTypeEntity> {

    /**
     * 分页列表
     *
     * @param mdmDictTypeReqVo
     * @return
     */
    PageResult<MdmDictTypeRespVo> findList(MdmDictTypeReqVo mdmDictTypeReqVo);

    /**
     * 通过id或者编码查询详情
     *
     * @param dictTypeCode
     * @param id
     * @return
     */
    MdmDictTypeRespVo query(String id, String dictTypeCode);

    /**
     * 新增
     *
     * @param reqVo
     */
    void save(MdmDictTypeReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     */
    void update(MdmDictTypeReqVo reqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 清除全部缓存
     */
    void deleteAllCache();

    /**
     * 根据id集合批量清除缓存
     *
     * @param ids
     */
    void deleteCacheByIds(List<String> ids);

    /**
     * 根据编码集合批量清除缓存
     *
     * @param codeList
     */
    void deleteCacheByCodeList(List<String> codeList);

    /**
     * 查询字典工具类缓存数据
     *
     * @param dictTypeCodeList
     * @return
     */
    List<DictGroupRedisVo> getDictGroupRedisList(List<String> dictTypeCodeList);

    /**
     * 仅数据同步查询使用
     * @param mdmSyncStandardDictReqVo vo
     * @return vo
     */
    MdmDictEngineSyncVo obtainSyncList(MdmSyncStandardDictReqVo mdmSyncStandardDictReqVo);
}

