package com.biz.crm.employeedirectory.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.employeedirectory.model.MdmEmployeeDirectoryEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 员工通讯录信息
 * @author yangshan
 * @date 2021/3/5 14:50
 */
public interface MdmEmployeeDirectoryMapper extends BaseMapper<MdmEmployeeDirectoryEntity> {

    /**
     * 列表
     * @return
     */
    @SqlPrivilege(posCode = "pos_code")
    List<MdmEmployeeDirectoryRespVo> findList();

    /**
     * 查询
     * @param posCodes 职位编码
     * @return
     */
    @SqlPrivilege(posCode = "pos_code")
    List<MdmEmployeeDirectoryRespVo> selectByPosCodes(@Param("posCodes") List<String> posCodes);

    /**
     * 查询
     * @param employeeCodes 人员编码
     * @return
     */
    @SqlPrivilege(posCode = "pos_code")
    List<MdmEmployeeDirectoryRespVo> selectByEmployeeCodes(@Param("employeeCodes") List<String> employeeCodes);
}
