package com.biz.crm.employeedirectory.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.employeedirectory.model.MdmEmployeeDirectoryEntity;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryListRespVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryReqVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryRespVo;

import java.util.List;
import java.util.Map;

/**
 * 员工通讯录信息接口
 * @author yangshan
 * @date 2021/3/5 14:51
 */
public interface MdmEmployeeDirectoryService extends IService<MdmEmployeeDirectoryEntity> {

    /**
     * 通讯录列表
     *
     * @return
     */
    List<MdmEmployeeDirectoryListRespVo> findList();

    /**
     * 新增
     *
     * @param reqVo
     */
    void save(MdmEmployeeDirectoryReqVo reqVo);

    /**
     * 删除(人员编码)
     *
     * @param employeeCodes
     */
    void deleteEmployeeCode(List<String> employeeCodes);

    /**
     * 删除(职位编码)
     *
     * @param posCodes
     */
    void deleteByPosCode(List<String> posCodes);
}
