package com.biz.crm.engineform.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.engineform.model.EngineFormListTemplateEntity;
import com.biz.crm.nebular.mdm.engineform.req.EngineFormListTemplateReqVo;
import com.biz.crm.nebular.mdm.engineform.resp.EngineFormListTemplateRespVo;

import java.util.List;

/**
 * 表单引擎模板的数据层描述接口
 *
 * @author jerry7
 * @date 2020-11-17 09:25:34
 */
public interface IEngineFormListTemplateService extends IService<EngineFormListTemplateEntity> {

    /**
     * 列表
     * @param engineFormListTemplateReqVo
     * @return PageResult<EngineFormListTemplateRespVo>
     */
    PageResult<EngineFormListTemplateRespVo> findList(EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 查询
     * @param engineFormListTemplateReqVo
     * @return EngineFormListTemplateRespVo
     */
    EngineFormListTemplateRespVo query(EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 新增
     * @param engineFormListTemplateReqVo
     * @return
     */
    void save(EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 更新
     * @param engineFormListTemplateReqVo
     * @return
     */
    void update(EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 删除
     * @param engineFormListTemplateReqVo
     * @return
     */
    void deleteBatch(EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 活动大类查询的表单列表
     * @return List<EngineFormListTemplateRespVo>
     */
    List<EngineFormListTemplateRespVo> activityFormList();
}

