package com.biz.crm.engineform.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.engineform.mapper.EngineFormListTemplateMapper;
import com.biz.crm.engineform.model.EngineFormListTemplateEntity;
import com.biz.crm.engineform.service.IEngineFormListTemplateService;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.engineform.req.EngineFormListTemplateReqVo;
import com.biz.crm.nebular.mdm.engineform.resp.EngineFormListTemplateRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import io.jsonwebtoken.lang.Assert;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 表单引擎模板的数据层描述接口实现
 *
 * @author jerry7
 * @date 2020-11-17 09:25:34
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "EngineFormListTemplateServiceExpandImpl")
public class EngineFormListTemplateServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<EngineFormListTemplateMapper, EngineFormListTemplateEntity> implements IEngineFormListTemplateService {

    @Resource
    private EngineFormListTemplateMapper engineFormListTemplateMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<EngineFormListTemplateRespVo> findList(EngineFormListTemplateReqVo reqVo) {
        Page<EngineFormListTemplateRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<EngineFormListTemplateRespVo> list = engineFormListTemplateMapper.findList(page, reqVo);
        return PageResult.<EngineFormListTemplateRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return engineFormListTemplateRespVo
     */
    @Override
    public EngineFormListTemplateRespVo query(EngineFormListTemplateReqVo reqVo) {
        return engineFormListTemplateMapper.query(reqVo);
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(EngineFormListTemplateReqVo reqVo) {
        EngineFormListTemplateEntity entity = CrmBeanUtil.copy(reqVo, EngineFormListTemplateEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(EngineFormListTemplateReqVo reqVo) {
        EngineFormListTemplateEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(EngineFormListTemplateReqVo reqVo) {
        List<EngineFormListTemplateEntity> engineFormListTemplateEntities = engineFormListTemplateMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty(engineFormListTemplateEntities)) {
            engineFormListTemplateEntities.forEach(o -> {
                o.setTStatus(0);
            });
        }
        this.updateBatchById(engineFormListTemplateEntities);
    }

    /**
     * 活动大类获取表单列表
     *
     * @return List<EngineFormListTemplateRespVo>
     */
    @Override
    public List<EngineFormListTemplateRespVo> activityFormList() {
        //1.从数据字典读取表单code
        //改成调用DictUtil了，不过这个方法查出来是树形结构，确定这里要的是树形结构吗？
        List<DictDataVo> tree = DictUtil.tree(TpmGlobalDictConstants.EVENT_APPLICATION_FORM);
        Assert.notNull(tree, "查询对应表单失败！");
        //2.从数据库查询对应的表单列表
        LambdaQueryWrapper<EngineFormListTemplateEntity> wrapper = Wrappers.<EngineFormListTemplateEntity>lambdaQuery().eq(EngineFormListTemplateEntity::getTStatus, 1);
        for (DictDataVo resp : tree) {
            wrapper.like(EngineFormListTemplateEntity::getCode, resp.getDictCode());
        }
        List<EngineFormListTemplateEntity> engineFormListTemplateEntities = engineFormListTemplateMapper.selectList(wrapper);
        return CrmBeanUtil.copyList(engineFormListTemplateEntities, EngineFormListTemplateRespVo.class);
    }
}
