package com.biz.crm.function.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionPermissionVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionSearchReqVo;
import com.biz.crm.nebular.mdm.sync.MdmFunctionEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardFunctionReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 菜单表
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
@Slf4j
@RestController
@RequestMapping("/mdmfunction")
@Api(tags = "菜单表")
@CrmGlobalLog
public class MdmFunctionController {

    @Autowired
    private MdmFunctionService mdmFunctionService;

    @ApiOperation("全部菜单列表")
    @PostMapping("/list")
    public Result<List<MdmFunctionRespVo>> listCondition(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.listCondition(mdmFunctionReqVo));
    }

    @ApiOperation("系统菜单列表")
    @PostMapping("/system_list")
    public Result<List<MdmFunctionRespVo>> systemList(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.systemList(mdmFunctionReqVo));
    }

    @ApiOperation("查询权限内的菜单列表")
    @PostMapping("/findPermissionFunctionList")
    public Result<List<MdmFunctionRespVo>> findPermissionFunctionList(MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.findPermissionFunctionList(mdmFunctionReqVo));
    }

    @ApiOperation("系统左侧菜单树")
    @PostMapping("/system_tree")
    public Result<List<MdmFunctionRespVo>> systemTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.systemTree(mdmFunctionReqVo));
    }

    @ApiModelProperty("页面引擎菜单树")
    @PostMapping("/pageEngineTree")
    @CrmDictMethod
    public Result<List<MdmFunctionPermissionVo>> pageEngineTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.pageEngineTree(mdmFunctionReqVo));
    }

    @ApiModelProperty("菜单管理树（查询已禁用的）")
    @PostMapping("/allFunctionTree")
    @CrmDictMethod
    public Result<List<MdmFunctionRespVo>> allFunctionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        List<MdmFunctionRespVo> data = mdmFunctionService.allFunctionTree(mdmFunctionReqVo);
        return Result.ok(data);
    }

    @ApiOperation("菜单树")
    @PostMapping("/tree")
    public Result<List<MdmFunctionRespVo>> functionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.functionTree(mdmFunctionReqVo));
    }

    @ApiOperation("菜单树（子节点查询）")
    @PostMapping("/functionSearchTree")
    public Result<List<MdmFunctionRespVo>> functionSearchTree(@RequestBody MdmFunctionSearchReqVo mdmFunctionSearchReqVo) {
        return Result.ok(mdmFunctionService.functionSearchTree(mdmFunctionSearchReqVo));
    }

    @ApiOperation(value = "查询")
    @PostMapping("/query")
    public Result<MdmFunctionRespVo> query(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        MdmFunctionRespVo respVo = mdmFunctionService.query(mdmFunctionReqVo);
        return Result.ok(respVo);
    }

    /**
     * 该方法更新，更新内容：新增了一个是否可配置工作流的字段
     *
     * @date: 2020/12/17 16:09
     * @author: YuanZiJian
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionService.save(mdmFunctionReqVo);
        return Result.ok();
    }

    /**
     * 查询可配置工作流的菜单
     *
     * @return com.biz.crm.util.Result<java.lang.Object>
     * @method listMdmFunctionByMenuConfig
     * @date: 2020/12/17 17:11
     * @author: YuanZiJian
     */
    @ApiOperation(value = "查询可配置工作流的菜单")
    @PostMapping("/getListMdmFunctionByMenuConfig")
    public Result<Object> listMdmFunctionByMenuConfig(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.listMdmFunctionByMenuConfig(mdmFunctionReqVo));
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionService.update(mdmFunctionReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation("查询配置数据权限的菜单树(数据权限专用)")
    @PostMapping("/findDataPermissionFunctionTree")
    public Result<List<MdmFunctionPermissionVo>> findDataPermissionFunctionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        return Result.ok(mdmFunctionService.findDataPermissionFunctionTree(mdmFunctionReqVo));
    }

    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionService.deleteBatch(mdmFunctionReqVo.getFunctionCode());
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionService.enableBatch(mdmFunctionReqVo.getFunctionCode());
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionService.disableBatch(mdmFunctionReqVo.getFunctionCode());
        return Result.ok("禁用成功");
    }

    @PostMapping("/syncList")
    public Result<MdmFunctionEngineSyncVo> syncList(@RequestBody MdmSyncStandardFunctionReqVo mdmSyncStandardFunctionReqVo) {
        return Result.ok(mdmFunctionService.syncList(mdmSyncStandardFunctionReqVo));
    }
}
