package com.biz.crm.function.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.nebular.mdm.function.*;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionTreeVo;
import com.biz.crm.nebular.mdm.sync.MdmFunctionEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardFunctionReqVo;

import java.util.List;
import java.util.Map;

/**
 * 菜单表接口
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
public interface MdmFunctionService extends IService<MdmFunctionEntity> {


    /**
     * 查询
     *
     * @param mdmFunctionReqVo vo
     * @return MdmFunctionRespVo
     */
    MdmFunctionRespVo query(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 新增
     *
     * @param mdmFunctionReqVo vo
     */
    void save(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 更新
     *
     * @param mdmFunctionReqVo vo
     */
    void update(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 删除
     *
     * @param functionCode 删除
     */
    void deleteBatch(String functionCode);

    /**
     * 启用
     *
     * @param functionCode vo
     */
    void enableBatch(String functionCode);

    /**
     * 禁用
     *
     * @param functionCode vo
     */
    void disableBatch(String functionCode);

    /**
     * 系统菜单列表
     *
     * @param mdmFunctionReqVo privilege
     * @return list
     */
    List<MdmFunctionRespVo> systemList(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询权限范围内的菜单列表
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> findPermissionFunctionList(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 系统菜单树
     *
     * @param mdmFunctionReqVo privilege
     * @return list
     */
    List<MdmFunctionRespVo> systemTree(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询当前用户关联的菜单编码
     *
     * @return list
     */
    List<String> findUserFunctionCodeList();

    /**
     * 获取当前用户权限下的菜单编码
     *
     * @return vo
     */
    MdmCheckAdminVo findCurrentUserFunctionCodeList();

    /**
     * 条件查询菜单编码集合
     *
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<String> conditionCodeList(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 全部菜单列表
     *
     * @param mdmFunctionReqVo privilege
     * @return list
     */
    List<MdmFunctionRespVo> listCondition(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询可配置工作流的菜单
     *
     * @return list
     */
    List<MdmFunctionRespVo> listMdmFunctionByMenuConfig(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 分页查询
     *
     * @param mdmFunctionReqVo vo
     * @return page
     */
    PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 角色管理（菜单树）
     *
     * @param mdmRoleFunctionReqVo vo
     * @return list
     */
    List<MdmRoleFunctionTreeVo> roleFunctionTree(MdmRoleFunctionReqVo mdmRoleFunctionReqVo);

    /**
     * 菜单树
     *
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> functionTree(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 菜单树构建
     *
     * @param functionName           菜单名称
     * @param mdmFunctionRespVos     列表
     * @param selectFunctionCodeList 过滤编码
     * @return list
     */
    List<MdmFunctionRespVo> constructFunctionTree(String functionName, List<MdmFunctionRespVo> mdmFunctionRespVos, List<String> selectFunctionCodeList);

    /**
     * 获取当前及下级菜单编码集合
     *
     * @param functionCode 当前菜单编码
     * @return list
     */
    List<String> findCurrentAndSubFunctionCodeList(String functionCode);

    /**
     * 菜单树
     *
     * @param mdmFunctionSearchReqVo
     * @return
     */
    List<MdmFunctionRespVo> functionSearchTree(MdmFunctionSearchReqVo mdmFunctionSearchReqVo);

    /**
     * 菜单扁平化打印
     *
     * @param list list
     * @return map
     */
    Map<String, String> flattenTree(List<MdmFunctionRespVo> list);

    /**
     * 求菜单树的深度
     *
     * @return int
     */
    Integer functionDepth();

    /**
     * 查询配置数据权限的菜单树(数据权限专用)
     *
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionPermissionVo> findDataPermissionFunctionTree(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 页面引擎菜单树
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionPermissionVo> pageEngineTree(MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 菜单管理树（查询已禁用的）
     * @param mdmFunctionReqVo vo
     * @return list
     */
    List<MdmFunctionRespVo> allFunctionTree(MdmFunctionReqVo mdmFunctionReqVo);

    MdmFunctionEngineSyncVo syncList(MdmSyncStandardFunctionReqVo mdmSyncStandardFunctionReqVo);
}

