package com.biz.crm.icon.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.icon.model.MdmIconEntity;
import com.biz.crm.nebular.mdm.icon.MdmIconReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconRespVo;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-12-05 11:10:24
 */
public interface IMdmIconService extends IService<MdmIconEntity> {

    /**
     * 列表
     * @param mdmIconReqVo
     * @return PageResult<MdmIconRespVo>
     */
    PageResult<MdmIconRespVo> findList(MdmIconReqVo mdmIconReqVo);

    /**
     * 查询
     * @param id id
     * @param iconCode 图标编码
     * @return MdmIconRespVo
     */
    MdmIconRespVo query(String id,String iconCode);

    /**
     * 新增
     * @param mdmIconReqVo
     * @return
     */
    void save(MdmIconReqVo mdmIconReqVo);

    /**
     * 更新
     * @param mdmIconReqVo
     * @return
     */
    void update(MdmIconReqVo mdmIconReqVo);

    /**
     * 删除
     * @param mdmIconReqVo
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param mdmIconReqVo
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param mdmIconReqVo
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 列表查询
     * @param mdmIconReqVo vo
     * @return list
     */
    List<MdmIconRespVo> listCondition(MdmIconReqVo mdmIconReqVo);
}

