package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.kms.service.MdmCustomerAccountService;
import com.biz.crm.nebular.mdm.kms.MdmCustomerAccountVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabStoreVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zxw
 * @date 2021-02-19 12:21
 **/
@RestController
@RequestMapping("/mdmCustomerAccountController")
@Api(tags = "kms客户帐号管理")
@CrmGlobalLog
public class MdmCustomerAccountController {

    @Resource
    private MdmCustomerAccountService mdmCustomerAccountService;

    @ApiOperation("分页查询")
    @PostMapping("/page")
    public Result<PageResult<MdmCustomerAccountVo>> page(@RequestBody MdmCustomerAccountVo mdmCustomerAccountVo) {
        return Result.ok(mdmCustomerAccountService.page(mdmCustomerAccountVo));
    }

    @ApiOperation("新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmCustomerAccountVo mdmCustomerAccountVo) {
        mdmCustomerAccountService.save(mdmCustomerAccountVo);
        return Result.ok();
    }

    @ApiOperation("编辑")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmCustomerAccountVo mdmCustomerAccountVo) {
        mdmCustomerAccountService.update(mdmCustomerAccountVo);
        return Result.ok();
    }

    @ApiOperation("删除")
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        mdmCustomerAccountService.delete(ids);
        return Result.ok();
    }

    @ApiOperation("客户关联的门店树")
    @PostMapping("/findGrabStoreList")
    public Result<List<KmsGrabStoreVo>> findGrabStoreList(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        return Result.ok(mdmCustomerAccountService.findGrabStoreList(mdmGrabRuleVo));
    }

}
