package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.kms.service.MdmDirectSystemService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 直营系统
 *
 * @author zxw
 * @date 2021-02-19 08:58
 **/
@RestController
@RequestMapping("/mdmDirectSystemController")
@Api(tags = "kms直营系统")
@CrmGlobalLog
public class MdmDirectSystemController {

    @Resource
    private MdmDirectSystemService mdmDirectSystemService;

    @ApiOperation("直营体系下拉框")
    @PostMapping("/directSystemSelect")
    public Result<List<MdmDirectSystemVo>> directSystemSelect(@RequestBody MdmDirectSystemVo mdmDirectSystemVo) {
        return Result.ok(mdmDirectSystemService.directSystemSelect(mdmDirectSystemVo));
    }

    @ApiOperation("启用")
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        mdmDirectSystemService.enable(ids);
        return Result.ok();
    }

    @ApiOperation("新增")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody MdmDirectSystemVo mdmDirectSystemVo) {
        mdmDirectSystemService.add(mdmDirectSystemVo);
        return Result.ok();
    }

    @ApiOperation("禁用")
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        mdmDirectSystemService.disable(ids);
        return Result.ok();
    }

    @ApiOperation("移除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody List<String> ids) {
        return Result.ok();
    }

    @ApiOperation("可新增的直营体系下拉框")
    @PostMapping("/unAddSelect")
    public Result<List<MdmDirectSystemVo>> unAddSelect(@RequestBody MdmDirectSystemVo mdmDirectSystemVo) {
        return Result.ok(mdmDirectSystemService.unAddSelect(mdmDirectSystemVo));
    }
}
