package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.kms.service.MdmGrabRuleService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabOrderTypeVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.MdmRuleParamVo;
import com.biz.crm.nebular.mdm.kms.api.KmsDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabStoreVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zxw
 * @date 2021-02-19 12:51
 **/
@RestController
@RequestMapping("/mdmGrabRuleController")
@CrmGlobalLog
@Api(tags = "kms单据抓取规则")
public class MdmGrabRuleController {

    @Resource
    private MdmGrabRuleService mdmGrabRuleService;

    @ApiOperation("单据类型列表")
    @PostMapping("/orderTypeList")
    public Result<List<MdmGrabOrderTypeVo>> orderTypeList(@RequestBody MdmDirectSystemVo mdmDirectSystemVo) {
        return Result.ok(mdmGrabRuleService.orderTypeList(mdmDirectSystemVo));
    }

    @ApiModelProperty("单据分页")
    @PostMapping("/page")
    public Result<PageResult<MdmGrabRuleVo>> page(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        return Result.ok(mdmGrabRuleService.page(mdmGrabRuleVo));
    }

    @ApiOperation("启用")
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        mdmGrabRuleService.enable(ids);
        return Result.ok();
    }

    @ApiOperation("禁用")
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        mdmGrabRuleService.disable(ids);
        return Result.ok();
    }

    @ApiOperation("查询详情")
    @PostMapping("/query")
    public Result<MdmGrabRuleVo> query(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        return Result.ok(mdmGrabRuleService.query(mdmGrabRuleVo));
    }

    @ApiOperation("删除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody List<String> ids) {
        mdmGrabRuleService.remove(ids);
        return Result.ok();
    }

    @ApiOperation("规则参数列表")
    @PostMapping("/paramList")
    public Result<List<MdmRuleParamVo>> paramList(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        return Result.ok(mdmGrabRuleService.paramList(mdmGrabRuleVo));
    }

    @ApiOperation("门店树")
    @PostMapping("/findGrabStoreList")
    public Result<List<KmsGrabStoreVo>> findGrabStoreList(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        return Result.ok(mdmGrabRuleService.findGrabStoreList(mdmGrabRuleVo));
    }

    @ApiOperation("保存")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        mdmGrabRuleService.save(mdmGrabRuleVo);
        return Result.ok();
    }

    @ApiOperation("编辑")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmGrabRuleVo mdmGrabRuleVo) {
        mdmGrabRuleService.update(mdmGrabRuleVo);
        return Result.ok();
    }
}