package com.biz.crm.kms.controller;

import com.biz.crm.kms.service.MdmProService;
import com.biz.crm.nebular.mdm.kms.api.KmsProVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zxw
 * @date 2021-03-08 15:56
 **/
@RestController
@RequestMapping("/mdmProController")
@Api(tags = "kms商品")
public class MdmProController {

    @Resource
    private MdmProService mdmProService;

    @ApiOperation("新增kms商品")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody KmsProVo kmsProVo) {
        mdmProService.add(kmsProVo);
        return Result.ok();
    }

    @ApiOperation("kms商品批量新增")
    @PostMapping("/addBatch")
    public Result<Object> addBatch(@RequestBody List<MdmProductReqVo> list) {
        mdmProService.add(list);
        return Result.ok();
    }

    @ApiOperation("修改kms商品")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody KmsProVo kmsProVo) {
        mdmProService.update(kmsProVo);
        return Result.ok();
    }

    @ApiOperation("删除kms商品")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody List<String> productCodeList) {
        mdmProService.remove(productCodeList);
        return Result.ok();
    }

    @ApiOperation("同步商品到kms")
    @PostMapping("/sync")
    public Result<Object> sync() {
        mdmProService.sync();
        return Result.ok();
    }
}
