package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.kms.service.MdmShelfProductService;
import com.biz.crm.nebular.mdm.kms.MdmProductUnitVo;
import com.biz.crm.nebular.mdm.kms.MdmShelfProductVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zxw
 * @date 2021-02-22 18:22
 **/
@RestController
@RequestMapping("/mdmShelfProductController")
@CrmGlobalLog
@Api(tags = "kms上架商品")
public class MdmShelfProductController {

    @Resource
    private MdmShelfProductService mdmShelfProductService;

    @ApiOperation("查询客户订货单位")
    @PostMapping("/findProductUnit")
    public Result<List<MdmProductUnitVo>> findProductUnit(@RequestBody MdmShelfProductVo mdmShelfProductVo) {
        return Result.ok(mdmShelfProductService.findProductUnit(mdmShelfProductVo));
    }

    @ApiOperation("查询详情")
    @PostMapping("/query")
    public Result<MdmShelfProductVo> query(@RequestBody MdmShelfProductVo mdmShelfProductVo) {
        return Result.ok(mdmShelfProductService.query(mdmShelfProductVo));
    }

    @ApiOperation("企业商品列表")
    @PostMapping("/findProductList")
    public Result<List<MdmShelfProductVo>> findProductList(@RequestBody MdmShelfProductVo mdmShelfProductVo) {
        return Result.ok(mdmShelfProductService.findProductList(mdmShelfProductVo));
    }

    @ApiModelProperty("上架产品分页列表")
    @PostMapping("/page")
    public Result<PageResult<MdmShelfProductVo>> page(@RequestBody MdmShelfProductVo mdmShelfProductVo) {
        return Result.ok(mdmShelfProductService.page(mdmShelfProductVo));
    }

    @ApiOperation("保存")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmShelfProductVo mdmShelfProductVo) {
        mdmShelfProductService.save(mdmShelfProductVo);
        return Result.ok();
    }

    @ApiOperation("删除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody List<String> ids) {
        mdmShelfProductService.remove(ids);
        return Result.ok();
    }
}
