package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.kms.service.MdmStoreService;
import com.biz.crm.nebular.mdm.kms.api.KmsStoreReplicaVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zxw
 * @date 2021-03-13 23:41
 **/
@RestController
@RequestMapping("/mdmStoreController")
@Api(tags = "kms门店")
@CrmGlobalLog
public class MdmStoreController {

    @Autowired
    private MdmStoreService mdmStoreService;

    @ApiOperation("新增")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody KmsStoreReplicaVo kmsStoreReplicaVo) {
        mdmStoreService.add(kmsStoreReplicaVo);
        return Result.ok();
    }

    @ApiOperation("批量新增")
    @PostMapping("/addBatch")
    public Result<Object> addBatch(@RequestBody List<MdmTerminalVo> list) {
        mdmStoreService.add(list);
        return Result.ok();
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody KmsStoreReplicaVo kmsStoreReplicaVo) {
        mdmStoreService.update(kmsStoreReplicaVo);
        return Result.ok();
    }

    @ApiOperation("删除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody List<String> ids) {
        mdmStoreService.remove(ids);
        return Result.ok();
    }

    @ApiOperation("主数据同步")
    @GetMapping("/sync")
    public Result<Object> sync() {
        mdmStoreService.sync();
        return Result.ok();
    }
}
