package com.biz.crm.kms.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.kms.service.MdmUnitService;
import com.biz.crm.nebular.mdm.kms.api.KmsUnitVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zxw
 * @date 2021-03-10 10:04
 **/
@RestController
@RequestMapping("/mdmUnitController")
@Slf4j
@Api(tags = "kms单位")
@CrmGlobalLog
public class MdmUnitController {

    @Autowired
    private MdmUnitService mdmUnitService;


    @ApiOperation("新增")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody KmsUnitVo kmsUnitVo) {
        mdmUnitService.add(kmsUnitVo);
        return Result.ok();
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody KmsUnitVo kmsUnitVo) {
        mdmUnitService.update(kmsUnitVo);
        return Result.ok();
    }

    @ApiOperation("删除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody List<String> ids) {
        mdmUnitService.remove(ids);
        return Result.ok();
    }

    @ApiOperation("同步kms单位")
    @PostMapping("/clear")
    public Result<Object> sync() {
        mdmUnitService.sync();
        return Result.ok();
    }
}
