package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.CrmDataSource;
import com.biz.crm.config.DataSourceType;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.KmsOrderTypeEnum;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.config.MapperConfig;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.model.*;
import com.biz.crm.kms.service.*;
import com.biz.crm.nebular.mdm.kms.api.*;
import com.bizunited.platform.common.util.JsonUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.logging.XMLFormatter;
import java.util.stream.Collectors;

/**
 * @author zxw
 * @date 2021-02-28 22:46
 **/
@Service
@ConditionalOnMissingBean(name = "KmsOrderServiceExpandImpl")
@CrmDataSource(DataSourceType.SLAVE)
@Slf4j
public class KmsOrderServiceImpl implements KmsOrderService {

    @Autowired
    private KmsProperties kmsProperties;

    @Autowired
    private DmsAcceptanceVoucherService dmsAcceptanceVoucherService;

    @Autowired
    private DmsIndentVoucherService dmsIndentVoucherService;

    @Autowired
    private DmsReturnVoucherService dmsReturnVoucherService;

    @Autowired
    private DmsPriceVoucherService dmsPriceVoucherService;

    @Autowired
    private DmsVoucherDetailService dmsVoucherDetailService;

    @Override
    public void fetchAcceptanceOrder() {
        KmsGrabRulePageVo kmsGrabRulePageVo = setUpOrderReq(kmsProperties.getAcceptanceInvoiceId());

        String url = kmsProperties.getUrl() + "/orderController/findOrderListByPage";

        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>> reference
                = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>>() {
        };

        ResponseEntity<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsAcceptanceVoucherVo>>>> entity = RestTemplateUtils.exchange(url, HttpMethod.POST, null, kmsGrabRulePageVo, reference);
        List<KmsAcceptanceVoucherVo> kmsAcceptanceVoucherVos = Optional.of(entity)
                .map(HttpEntity::getBody)
                .map(KmsResultVo::getData)
                .map(KmsResultBodyVo::getBody)
                .map(KmsPageResultVo::getRows)
                .orElse(null);
        if (CollectionUtils.isEmpty(kmsAcceptanceVoucherVos)) {
            return;
        }
        List<DmsAcceptanceVoucherEntity> list = KmsConverter.INSTANCE.acceptance2entity(kmsAcceptanceVoucherVos);

        Collection<DmsAcceptanceVoucherEntity> values = list.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()
                , BinaryOperator.maxBy(Comparator.comparing(x -> x.getAcceptanceDate() != null
                        ? x.getAcceptanceDate()
                        : YesNoEnum.yesNoEnum.ZERO.getValue()))))
                .values();
        list = new ArrayList<>(values);
        List<String> collect = list.stream().map(DmsAcceptanceVoucherEntity::getOrderNumber).collect(Collectors.toList());
        System.out.println(1);
        saveDetail(collect,kmsProperties.getAcceptanceInvoiceId(),KmsOrderTypeEnum.ACCEPTANCE.getCode());
        dmsAcceptanceVoucherService.saveOrUpdateBatch(list);
    }

    @Override
    public void fetchIndentOrder() {
        KmsGrabRulePageVo kmsGrabRulePageVo = setUpOrderReq(kmsProperties.getIndentInvoiceId());

        String url = kmsProperties.getUrl() + "/orderController/findOrderListByPage";

        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>> reference
                = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>>() {
        };

        ResponseEntity<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsIndentVoucherVo>>>> entity = RestTemplateUtils.exchange(url, HttpMethod.POST, null, kmsGrabRulePageVo, reference);
        List<KmsIndentVoucherVo> kmsIndentVoucherVos = Optional.of(entity)
                .map(HttpEntity::getBody)
                .map(KmsResultVo::getData)
                .map(KmsResultBodyVo::getBody)
                .map(KmsPageResultVo::getRows)
                .orElse(null);
        if (CollectionUtils.isEmpty(kmsIndentVoucherVos)) {
            return;
        }
        List<DmsIndentVoucherEntity> list = KmsConverter.INSTANCE.indent2entity(kmsIndentVoucherVos);
        Collection<DmsIndentVoucherEntity> values = list.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()
                , BinaryOperator.maxBy(Comparator.comparing(x -> x.getOrderDate() != null
                        ? x.getOrderDate()
                        : YesNoEnum.yesNoEnum.ZERO.getValue()))))
                .values();
        list = new ArrayList<>(values);
        List<String> collect = list.stream().map(DmsIndentVoucherEntity::getOrderNumber).collect(Collectors.toList());
        saveDetail(collect,kmsProperties.getIndentInvoiceId(), KmsOrderTypeEnum.INDENT.getCode());
        dmsIndentVoucherService.saveOrUpdateBatch(list);
    }

    private void saveDetail(List<String> orderNumberList,String bsInvoiceId,int orderType) {
        if(CollectionUtils.isEmpty(orderNumberList)){
            return;
        }
        Collection<KmsOrderDetailEntity> values = orderNumberList.parallelStream()
                .filter(x -> !StringUtils.isEmpty(x))
                .flatMap(x -> obtainDetails(x, bsInvoiceId).stream())
                .peek(x -> x.setKmsOrderType(orderType))
                .map(KmsConverter.INSTANCE::order2Entity)
                .collect(Collectors.toMap(BaseIdEntity::getId, Function.identity(), (x1, x2) -> x2))
                .values();
        ArrayList<KmsOrderDetailEntity> collect = new ArrayList<>(values);
        if(!CollectionUtils.isEmpty(collect)){
            dmsVoucherDetailService.saveOrUpdateBatch(collect);
        }
    }


    @Override
    public void fetchPriceOrder() {
        KmsGrabRulePageVo kmsGrabRulePageVo = setUpOrderReq(kmsProperties.getPriceInvoicedId());

        String url = kmsProperties.getUrl() + "/orderController/findOrderListByPage";

        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>> reference
                = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>>() {
        };

        ResponseEntity<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsPriceVoucherVo>>>> entity = RestTemplateUtils.exchange(url, HttpMethod.POST, null, kmsGrabRulePageVo, reference);
        List<KmsPriceVoucherVo> kmsPriceVoucherVos = Optional.ofNullable(entity)
                .map(HttpEntity::getBody)
                .map(KmsResultVo::getData)
                .map(KmsResultBodyVo::getBody)
                .map(KmsPageResultVo::getRows)
                .orElse(null);
        if (CollectionUtils.isEmpty(kmsPriceVoucherVos)) {
            return;
        }
        List<DmsPriceVoucherEntity> list = KmsConverter.INSTANCE.price2entity(kmsPriceVoucherVos);

        dmsPriceVoucherService.saveOrUpdateBatch(list);
    }


    @Override
    public void fetchReturnOrder() {
        KmsGrabRulePageVo kmsGrabRulePageVo = setUpOrderReq(kmsProperties.getReturnInvoiceId());

        String url = kmsProperties.getUrl() + "/orderController/findOrderListByPage";

        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>> reference
                = new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>>() {
        };

        ResponseEntity<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsReturnVoucherVo>>>> entity = RestTemplateUtils.exchange(url, HttpMethod.POST, null, kmsGrabRulePageVo, reference);
        List<KmsReturnVoucherVo> kmsReturnVoucherVos = Optional.of(entity)
                .map(HttpEntity::getBody)
                .map(KmsResultVo::getData)
                .map(KmsResultBodyVo::getBody)
                .map(KmsPageResultVo::getRows)
                .orElse(null);
        if (CollectionUtils.isEmpty(kmsReturnVoucherVos)) {
            return;
        }
        List<DmsReturnVoucherEntity> list = KmsConverter.INSTANCE.return2entity(kmsReturnVoucherVos);
        Collection<DmsReturnVoucherEntity> values = list.stream()
                .collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()
                        , BinaryOperator.maxBy(Comparator.comparing(x -> x.getOrderDate() != null
                                ? x.getOrderDate()
                                : YesNoEnum.yesNoEnum.ZERO.getValue()))))
                .values();
        list = new ArrayList<>(values);
        List<String> collect = list.stream().map(DmsReturnVoucherEntity::getOrderNumber).collect(Collectors.toList());
        saveDetail(collect,kmsProperties.getReturnInvoiceId(),KmsOrderTypeEnum.RETURN.getCode());
        dmsReturnVoucherService.saveOrUpdateBatch(list);
    }

    protected KmsGrabRulePageVo setUpOrderReq(String bsInvoiceId) {
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setBsInvoiceId(bsInvoiceId);
        kmsGrabRuleVo.setFieldCategory("INVOICE");
        KmsPageVo kmsPageVo = new KmsPageVo(0, -1);
        KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
        kmsGrabRulePageVo.setPage(kmsPageVo);
        kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
        kmsGrabRulePageVo.setTenantryId(kmsProperties.getTenantryId());
        kmsGrabRulePageVo.setUserId(kmsProperties.getUserId());
        kmsGrabRulePageVo.setUsername(kmsProperties.getUsername());
        return kmsGrabRulePageVo;
    }

    @Override
    public List<KmsOrderDetailVo> obtainDetails(String orderNumber, String bsInvoiceId) {
        if(StringUtils.isEmpty(orderNumber)||StringUtils.isEmpty(bsInvoiceId)){
            return null;
        }
        ObjectNode instance = MapperConfig.instance(kmsProperties,1,-1);
        ObjectNode req = MapperConfig.instance();
        req.put("bsInvoiceId", bsInvoiceId);
        req.put("fieldCategory", "GOODS");
        req.put("isEdit", 0);
        req.put("isSplit", 0);
        req.put("orderNumber", orderNumber);
        req.put("versionNumber", 1);
        req.put("tenantryId", kmsProperties.getTenantryId());
        instance.set("reqVo", req);

        ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsOrderDetailVo>>>> reference =
                new ParameterizedTypeReference<KmsResultVo<KmsResultBodyVo<KmsPageResultVo<KmsOrderDetailVo>>>>() {};
        String url = kmsProperties.getUrl() + "/orderController/getOrderDetail";

        return Optional.of(RestTemplateUtils.exchange(url, HttpMethod.POST, null, instance, reference))
                .map(x -> {
                    log.info("[kms订单详情][remove]entity:{}", x);
                    return x;
                })
                .map(HttpEntity::getBody)
                .filter(x -> MapperConfig.SUCCESS.equals(x.getCode()))
                .map(KmsResultVo::getData)
                .map(KmsResultBodyVo::getBody)
                .map(KmsPageResultVo::getRows)
                .orElse(new ArrayList<>());
    }


}
