package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmDmsOfficialAccountsLoginService;
import com.biz.crm.nebular.mdm.login.MdmLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginAesUtil;
import com.biz.crm.utils.LoginEncryptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/mdmDmsOfficialAccountsLoginController")
@Api(tags = "MDM-登录登出-DMS微信公众号")
@CrmGlobalLog
public class MdmDmsOfficialAccountsLoginController {

    @Autowired
    private MdmDmsOfficialAccountsLoginService mdmDmsOfficialAccountsLoginService;

    @ApiOperation("登录（账号+密码）")
    @PostMapping("/login")
    public Result<MdmLoginRespVo> login(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.login(revert(reqVo)));
    }

    @ApiOperation("登录（手机号+密码）")
    @PostMapping("/loginByPhone")
    public Result<MdmLoginRespVo> loginByPhone(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.loginByPhone(revert(reqVo)));
    }

    @ApiOperation("登录（邮箱+密码）")
    @PostMapping("/loginByEmail")
    public Result<MdmLoginRespVo> loginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.loginByEmail(revert(reqVo)));
    }

    @ApiOperation("登录（手机号+验证码）")
    @PostMapping("/loginByPhoneVerification")
    public Result<MdmLoginRespVo> loginByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.loginByPhoneVerification(revert(reqVo)));
    }

    @ApiOperation("登录（邮箱+验证码）")
    @PostMapping("/loginByEmailVerification")
    public Result<MdmLoginRespVo> loginByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.loginByEmailVerification(revert(reqVo)));
    }

    @ApiOperation("发送手机号登录验证码")
    @PostMapping("/sendVerificationForLoginByMessage")
    public Result sendVerificationForLoginByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmDmsOfficialAccountsLoginService.sendVerificationForLoginByMessage(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("发送邮箱登录验证码")
    @PostMapping("/sendVerificationForLoginByEmail")
    public Result sendVerificationForLoginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmDmsOfficialAccountsLoginService.sendVerificationForLoginByEmail(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("发送重置密码验证码（手机号）")
    @PostMapping("/sendVerificationForLoginAndResetByMessage")
    public Result sendVerificationForLoginAndResetByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmDmsOfficialAccountsLoginService.sendVerificationForLoginAndResetByMessage(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("发送重置密码验证码（邮箱）")
    @PostMapping("/sendVerificationForLoginAndResetByEmail")
    public Result sendVerificationForLoginAndResetByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmDmsOfficialAccountsLoginService.sendVerificationForLoginAndResetByEmail(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("校验手机号是否存在且可用")
    @PostMapping("/checkPhoneExistAndUsable")
    public Result checkPhoneExistAndUsable(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmDmsOfficialAccountsLoginService.checkPhoneExistAndUsable(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("校验邮箱是否存在且可用")
    @PostMapping("/checkEmailExistAndUsable")
    public Result checkEmailExistAndUsable(@RequestBody MdmLoginEncryptReqVo reqVo) {
        mdmDmsOfficialAccountsLoginService.checkEmailExistAndUsable(revert(reqVo));
        return Result.ok();
    }

    @ApiOperation("验证重置密码验证码并登录（手机号+验证码）")
    @PostMapping("/loginAndResetByPhoneVerification")
    public Result<MdmLoginRespVo> loginAndResetByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.loginAndResetByPhoneVerification(revert(reqVo)));
    }

    @ApiOperation("验证重置密码验证码并登录（邮箱+验证码）")
    @PostMapping("/loginAndResetByEmailVerification")
    public Result<MdmLoginRespVo> loginAndResetByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok(mdmDmsOfficialAccountsLoginService.loginAndResetByEmailVerification(revert(reqVo)));
    }

    @ApiOperation("获取登录方式的控制参数")
    @PostMapping("/getLoginTypeControlConfig")
    public Result<MdmLoginTypeControlVo> getLoginTypeControlConfig() {
        return Result.ok(mdmDmsOfficialAccountsLoginService.getLoginTypeControlConfig());
    }

    @ApiOperation("退出登录（退出当前会话）")
    @PostMapping("/logout")
    public Result logout() {
        UserUtils.logout();
        return Result.ok();
    }

    @ApiOperation("退出登录（退出当前会话账号在DMS手机APP的全部会话）")
    @PostMapping("/logoutFromType")
    public Result logoutFromType() {
        UserUtils.logout(LoginFromTypeEnum.OFFICIAL_ACCOUNTS_DMS.getValue());
        return Result.ok();
    }

    @ApiOperation("退出登录（退出当前会话账号在所有平台的全部会话）")
    @PostMapping("/logoutAll")
    public Result logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null && StringUtils.isNotEmpty(user.getUsername())) {
            UserUtils.deleteUser(user.getUsername());
        }
        return Result.ok();
    }

    /**
     * 把加密参数转换成已有参数
     *
     * @param reqVo
     * @return
     */
    private MdmLoginReqVo revert(MdmLoginEncryptReqVo reqVo) {
        ThreadLocalUtil.delObj();
        MdmLoginReqVo loginReqVo = new MdmLoginReqVo();
        if (StringUtils.isNotEmpty(reqVo.getUjlrwebjruzddjnu())) {
            loginReqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isNotEmpty(reqVo.getPthxivgijazekrss())) {
            loginReqVo.setPassword(LoginAesUtil.decrypt(reqVo.getPthxivgijazekrss()));
        } else if (StringUtils.isNotEmpty(reqVo.getPazjofxkyvyoosot())) {
            loginReqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
        } else if (StringUtils.isNotEmpty(reqVo.getPenijmgsbybkfjvr())) {
            loginReqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
        } else {

        }
        if (StringUtils.isNotEmpty(reqVo.getTwpbmjhfxodboggf())) {
            loginReqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
        }
        if (StringUtils.isNotEmpty(reqVo.getExzvsxwhvcvcctyk())) {
            loginReqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
        }
        if (StringUtils.isNotEmpty(reqVo.getVfymxygsefoeapvk())) {
            loginReqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
        }
        if (StringUtils.isNotEmpty(reqVo.getRegistrationId())){
            loginReqVo.setRegistrationId(reqVo.getRegistrationId());
        }
        loginReqVo.setFromType(LoginFromTypeEnum.OFFICIAL_ACCOUNTS_DMS.getValue());
        return loginReqVo;
    }


}
