package com.biz.crm.login.controller;

import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.*;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 登出控制器
 *
 * @author zxw
 * @date 2020-11-19 13:58
 **/
@RestController
@RequestMapping("/logout")
@Api(tags = "登出控制器（过期）")
public class MdmLogoutController {

    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;
    @Autowired
    private MdmDmsMallLoginService mdmDmsMallLoginService;
    @Autowired
    private MdmSfaAppletLoginService mdmSfaAppletLoginService;
    @Autowired
    private MdmSfaAppLoginService mdmSfaAppLoginService;
    @Autowired
    private MdmDmsAppLoginService mdmDmsAppLoginService;

    @ApiOperation("全平台退出")
    @PostMapping("/logout")
    public Result<Object> logout() {
        UserUtils.remove();
        return Result.ok();
    }

    @ApiOperation("系统登出")
    @PostMapping("/system")
    public Result<Object> systemLogout(HttpServletRequest request) {
        UserUtils.logout();
        return Result.ok();
    }

    @ApiOperation("dms商城后台登出")
    @PostMapping("/dms_mall")
    public Result<Object> dmsMallLogout() {
        UserUtils.logout(LoginFromTypeEnum.WEB_DMS.getValue());
        return Result.ok();
    }

    @ApiOperation("dmsapp登出")
    @PostMapping("/dms_app")
    public Result<Object> dmsAppLogout() {
        UserUtils.logout(LoginFromTypeEnum.APP_DMS.getValue());
        return Result.ok();
    }

    @ApiOperation("dms小程序登出")
    @PostMapping("/dms_applet")
    public Result<Object> dmsAppletLogout() {
        UserUtils.logout(LoginFromTypeEnum.APPLET_DMS.getValue());
        return Result.ok();
    }

    @ApiOperation("sfa小程序登出")
    @PostMapping("/sfa_applet")
    public Result<Object> sfaAppletLogout() {
        mdmSfaAppletLoginService.logoutFromType();
        return Result.ok();
    }

    @ApiOperation("sfaapp登出")
    @PostMapping("/sfa_app")
    public Result<Object> sfaAppLogout() {
        UserUtils.logout(LoginFromTypeEnum.APP_SFA.getValue());
        return Result.ok();
    }
}
