package com.biz.crm.login.service;

import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;

/**
 * @author zxw
 */
public interface MdmSystemLoginService {

    /**
     * 账号密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo login(MdmLoginReqVo reqVo);

    /**
     * 使用用户名登录，一般用于外部系统认证
     *
     * @param reqVo 必传userName，选填fromType
     * @return
     */
    MdmLoginRespVo loginByOnlyUserName(MdmLoginReqVo reqVo);

    /**
     * 手机号密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo);

    /**
     * 邮箱密码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo);

    /**
     * 手机号+验证码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo);

    /**
     * 邮箱+验证码登录
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo);

    /**
     * 校验手机号是否可用
     *
     * @param reqVo
     */
    void checkPhoneExistAndUsable(MdmLoginReqVo reqVo);

    /**
     * 校验邮箱是否可用
     *
     * @param reqVo
     */
    void checkEmailExistAndUsable(MdmLoginReqVo reqVo);

    /**
     * 发送手机号登录验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo);

    /**
     * 发送邮箱登录验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo);

    /**
     * 手机号+验证码登录并需要重置密码
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo);

    /**
     * 邮箱+验证码登录并且需要重置密码
     *
     * @param reqVo
     * @return
     */
    MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo);

    /**
     * 发送手机号登录（并重置）验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo);

    /**
     * 发送邮箱登录（并重置）验证码
     *
     * @param reqVo
     */
    void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo);

    /**
     * 获取登录方式控制
     *
     * @return
     */
    MdmLoginTypeControlVo getLoginTypeControlConfig();

    /**
     * 退出登录（退出当前会话）
     */
    void logout();

    /**
     * 退出登录（退出当前会话账号在后台的全部会话）
     */
    void logoutFromType();

    /**
     * 退出登录（退出当前会话账号在所有平台的全部会话）
     */
    void logoutAll();

    /**
     * 通过token查询用户信息
     * @return
     */
    MdmLoginRespVo findUserByToken();
}
