package com.biz.crm.login.service;

import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;

import java.util.List;

/**
 * @ClassName: MdmTerminalAppletLoginService
 * @Author: yangfan
 * @Description: MDM终端登入登出service接口
 * @Date: 2021/8/18 10:09
 * @Version: 1.0
 */
public interface MdmTerminalAppletLoginService {

  /**
   * 账号密码登录
   *
   * @param reqVo
   * @return
   */
  MdmLoginRespVo login(MdmAppletLoginReqVo reqVo);

  /**
   * 手机号密码登录
   *
   * @param reqVo
   * @return
   */
  MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo);

  /**
   * 登录(openId+手机号+终端编码/客户编码)
   *
   * @param reqVo
   * @return
   */
  MdmLoginRespVo loginByOpenIdAndPhoneAndCode(MdmAppletLoginReqVo reqVo);

  /**
   * 手机号+验证码登录
   *
   * @param reqVo
   * @return
   */
  MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo);

  /**
   * 发送手机号登录验证码
   *
   * @param reqVo
   */
  void sendVerificationForLoginByMessage(MdmAppletLoginReqVo reqVo);

  /**
   * 通过openId登录
   *
   * @param reqVo
   * @return
   */
  MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo);

  /**
   * 发送手机号登录（并重置）验证码
   *
   * @param reqVo
   */
  void sendVerificationForLoginAndResetByMessage(MdmAppletLoginReqVo reqVo);

  /**
   * 校验手机号是否可用
   *
   * @param reqVo
   */
  void checkPhoneExistAndUsable(MdmAppletLoginReqVo reqVo);

  /**
   * 手机号+验证码登录并需要重置密码
   *
   * @param reqVo
   * @return
   */
  MdmLoginRespVo loginAndResetByPhoneVerification(MdmAppletLoginReqVo reqVo);

  /**
   * 通过手机号重置密码
   * @param phoneCode
   * @param password
   */
  void resetPasswordByPhone(String phoneCode, String password);

  /**
   * 获取登录方式控制
   *
   * @return
   */
  MdmLoginTypeControlVo getLoginTypeControlConfig();

  /**
   * 退出登录（退出当前会话）
   */
  void logout();

  /**
   * 退出登录（退出当前会话账号在后台的全部会话）
   */
  void logoutFromType();

  /**
   * 退出登录（退出当前会话账号在所有平台的全部会话）
   */
  void logoutAll();

  /**
   * 终端注册时验证手机号码
   * @param phoneCode
   */
  void sendTerminalVerificationByMessage(String phoneCode);

  /**
   * 校验 验证码对应的电话号码是否一致
   * @param phoneCode,verificationCode
   * @return
   */
  Boolean VerificationPhoneByCode(String phoneCode,String verificationCode);

  /**
   * 获取用户信息
   * @param userName
   * @param terminalCode
   */
  void switchoverTerminal(MdmAppletLoginReqVo reqVo);

  /**
   * 通过手机号查询终端详细信息
   * @param phoneCode 手机号
   * @return List<MdmTerminalVo>
   */
  List<MdmTerminalVo> getTerminalByPhone (String phoneCode);
}
