package com.biz.crm.login.service.impl;

import com.biz.crm.login.service.MdmDmsAppletLoginService;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Slf4j
@ConditionalOnMissingBean(name = "MdmDmsAppletLoginServiceExpandImpl")
public class MdmDmsAppletLoginServiceImpl implements MdmDmsAppletLoginService {

    @Autowired
    private MdmDmsMallLoginService mdmDmsMallLoginService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo login(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.login(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByPhone(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.loginByPhone(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByEmail(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.loginByEmail(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByPhoneVerification(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.loginByPhoneVerification(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginByEmailVerification(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.loginByEmailVerification(reqVo);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmLoginReqVo reqVo) {
        mdmDmsMallLoginService.sendVerificationForLoginByMessage(reqVo);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmLoginReqVo reqVo) {
        mdmDmsMallLoginService.sendVerificationForLoginByEmail(reqVo);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmLoginReqVo reqVo) {
        mdmDmsMallLoginService.checkPhoneExistAndUsable(reqVo);
    }

    @Override
    public void checkEmailExistAndUsable(MdmLoginReqVo reqVo) {
        mdmDmsMallLoginService.checkEmailExistAndUsable(reqVo);
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmLoginReqVo reqVo) {
        mdmDmsMallLoginService.sendVerificationForLoginAndResetByMessage(reqVo);
    }

    @Override
    public void sendVerificationForLoginAndResetByEmail(MdmLoginReqVo reqVo) {
        mdmDmsMallLoginService.sendVerificationForLoginAndResetByEmail(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.loginAndResetByPhoneVerification(reqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MdmLoginRespVo loginAndResetByEmailVerification(MdmLoginReqVo reqVo) {
        return mdmDmsMallLoginService.loginAndResetByEmailVerification(reqVo);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        return mdmDmsMallLoginService.getLoginTypeControlConfig();
    }
}
