package com.biz.crm.login.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.dict.mapper.MdmDictDataMapper;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.login.service.MdmLoginHelpService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.login.service.MdmTerminalAppletLoginService;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalLoginVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.service.RedisService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.utils.LoginHelpUtil;
import com.biz.crm.webservice.message.ShortMessageFeign;

import java.util.*;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/**
 * @ClassName: MdmTerminalAppletLoginServiceImpl
 * @Author: yangfan
 * @Description: MDM终端登入登出service实现
 * @Date: 2021/8/18 10:10
 * @Version: 1.0
 */
@Service
@Slf4j
@ConditionalOnMissingBean(name = "MdmTerminalAppletLoginServiceExpandImpl")
public class MdmTerminalAppletLoginServiceImpl implements MdmTerminalAppletLoginService {

  @Autowired
  private MdmUserRelWeChatService mdmUserRelWeChatService;
  @Resource
  private MdmUserService mdmUserService;
  @Resource
  private MdmPositionService mdmPositionService;
  @Resource
  private MdmUserLoginLogService mdmUserLoginLogService;
  @Resource
  private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;
  @Resource
  private MdmSystemLoginService mdmSystemLoginService;
  @Resource
  private MdmOrgService mdmOrgService;
  @Resource
  private MdmLoginHelpService mdmLoginHelpService;
  @Resource
  private MdmTerminalService mdmTerminalService;
  @Resource
  private MdmCustomerMsgService mdmCustomerMsgService;
  @Resource
  private MdmCustomerROrgService mdmCustomerROrgService;
  @Resource
  private RedisService redisService;
  @Resource
  private MdmDictDataService mdmDictDataService;
  @Resource
  private MdmTerminalMapper mdmTerminalMapper;

  @Autowired(required = false)
  private ShortMessageFeign shortMessageFeign;


  @Override
  public MdmLoginRespVo login(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserName(), "缺失账号");
    Assert.hasText(reqVo.getPassword(), "缺失密码");
    // Assert.hasText(reqVo.getOpenId(), "缺失openId");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
    //校验用户类型
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    //校验用户可用性
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    //校验密码
    if (Md5EncryptionAndDecryption.checkPwd(reqVo.getPassword(), user.getUserPassword())) {
      mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
    } else {
      mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
    }
    return doLoginThisSystem(user, reqVo, true, false, true);
  }

  @Override
  public MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    Assert.hasText(reqVo.getPassword(), "缺失密码");
    //Assert.hasText(reqVo.getOpenId(), "缺失openId");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
    //校验用户类型
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    //校验用户可用性
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    //校验密码
    if (Md5EncryptionAndDecryption.checkPwd(reqVo.getPassword(), user.getUserPassword())) {
      mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
    } else {
      mdmLoginHelpService.addError(user.getUserName(), user.getUserPhone(), user.getEmail());
    }
    return doLoginThisSystem(user, reqVo, true, false, true);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    Assert.hasText(reqVo.getVerificationCode(), "缺失验证码");
   // Assert.hasText(reqVo.getOpenId(), "缺失openId");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
    //根据验证码+手机号获取当时的用户
    String userName = mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(userName, null, null);
    Assert.isTrue(reqVo.getUserPhone().equals(user.getUserPhone()), "手机号关联用户发生变化，请重新登录");
    //校验用户类型
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    //校验用户状态
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    //解锁
    mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
    return doLoginThisSystem(user, reqVo, true, false, true);
  }

  @Override
  public void sendVerificationForLoginByMessage(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    // Assert.hasText(reqVo.getOpenId(), "缺失openId");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
    mdmLoginHelpService.checkLock(user.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
    mdmLoginHelpService.checkLock(user.getEmail(), LoginHelpUtil.AccountType.EMAIL);
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    String verification = mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
    //发送短信
    mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN);
  }

  @Override
  public MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo) {
    String openId = reqVo.getOpenId();
    Assert.hasText(openId, "缺失openId");
    List<MdmUserRelWeChatRespVo> list = mdmUserRelWeChatService.getBindUserListByOpenId(openId, LoginFromTypeEnum.APPLET_SFA.getValue());
    Assert.notEmpty(list, "微信未绑定任何用户");
    Assert.isTrue(list.size() == 1, "微信绑定了多个用户");
    MdmUserRelWeChatRespVo one = list.get(0);
    if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue(ParameterParam.SFA_APPLET_USER_UNIQUE_FLAG))) {
      List<MdmUserRelWeChatRespVo> userRelList = mdmUserRelWeChatService.getBindWeChatListByUserName(one.getUserName(), LoginFromTypeEnum.APPLET_SFA.getValue());
      Assert.isTrue(userRelList.size() == 1, "用户绑定了多个微信，请先在后台解绑");
    }
    Assert.isTrue(YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), "处于退出登录状态，需要重新登录");

    mdmLoginHelpService.checkLock(one.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
    MdmUserRespVo user = mdmUserService.getUserForLogin(one.getUserName(), null, null);
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
    return doLoginThisSystem(user, reqVo, true, false, false);
  }

  @Override
  public MdmLoginRespVo loginByOpenIdAndPhoneAndCode(MdmAppletLoginReqVo reqVo) {
    if (StringUtils.isEmpty(reqVo.getTerminalCode()) && StringUtils.isEmpty(reqVo.getCustomerCode())){
      throw new BusinessException("请输入终端编码或客户编码");
    }
    String openId = reqVo.getOpenId();
    if (StringUtils.isNotEmpty(openId)){
      Assert.hasText(openId, "缺失openId");
      List<MdmUserRelWeChatRespVo> list = mdmUserRelWeChatService.getBindUserListByOpenId(openId, LoginFromTypeEnum.APPLET_SFA.getValue());
      Assert.notEmpty(list, "微信未绑定任何用户");
      Assert.isTrue(list.size() == 1, "微信绑定了多个用户");
      MdmUserRelWeChatRespVo one = list.get(0);
      if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue(ParameterParam.SFA_APPLET_USER_UNIQUE_FLAG))) {
        List<MdmUserRelWeChatRespVo> userRelList = mdmUserRelWeChatService.getBindWeChatListByUserName(one.getUserName(), LoginFromTypeEnum.APPLET_SFA.getValue());
        Assert.isTrue(userRelList.size() == 1, "用户绑定了多个微信，请先在后台解绑");
      }
      Assert.isTrue(YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), "处于退出登录状态，需要重新登录");

      mdmLoginHelpService.checkLock(one.getUserName(), LoginHelpUtil.AccountType.USER_NAME);
      MdmUserRespVo user = mdmUserService.getUserForLogin(one.getUserName(), null, null);
      mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
      mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
      mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
    }
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
    //校验用户类型
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    //校验用户可用性
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());

    MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();

    String token = UUID.randomUUID().toString().replaceAll("-", "");
    //生成登录信息
    UserRedis userRedis = new UserRedis();
    userRedis.setUsername(user.getUserName());
    userRedis.setRealname(user.getFullName());
    userRedis.setUsertype(user.getUserType());
    mdmLoginRespVo.setUserCode(user.getUserCode());
    mdmLoginRespVo.setLoginUserToken(token);
    mdmLoginRespVo.setUserName(user.getUserName());
    mdmLoginRespVo.setFullName(user.getFullName());
    mdmLoginRespVo.setUserType(user.getUserType());
    mdmLoginRespVo.setLanguage(userRedis.getLanguage());
    if (UserTypeEnum.TERMINAL.getCode().equals(user.getUserType())) {
      List<MdmTerminalVo> terminalList = mdmTerminalService.findTerminalByUserName(user.getUserName());
      if (CollectionUtil.listEmpty(terminalList)) {
        throw new BusinessException("当前账号未关联可用的终端，请联系管理员");
      }
      for (MdmTerminalVo mdmTerminalVo : terminalList) {
        if (!mdmTerminalVo.getTerminalCode().equals(reqVo.getTerminalCode())){
          terminalList.remove(mdmTerminalVo);
        }
      }
      if (terminalList.size() == 0){
        throw new BusinessException("终端编码不匹配，请联系管理员");
      }else {
        List<MdmTerminalLoginVo> mdmTerminalLoginVos = CrmBeanUtil.copyList(terminalList, MdmTerminalLoginVo.class);
        mdmLoginRespVo.setTerminalVoList(mdmTerminalLoginVos);
        //todo 有多个终端信息 先默认返回第一个终端信息 规则以后再定
        MdmTerminalVo mdmTerminalVo = terminalList.get(0);
        if(mdmTerminalVo!=null){
          userRedis.setCustcode(mdmTerminalVo.getTerminalCode());
          userRedis.setCustname(mdmTerminalVo.getTerminalName());
          userRedis.setOrgcode(mdmTerminalVo.getOrgCode());
          userRedis.setOrgname(mdmTerminalVo.getOrgName());
        }
      }
    }else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUserType())) {
      MdmCustomerMsgRespVo customer = mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
      if (customer == null) {
        throw new BusinessException("当前账号未关联可用的客户，请联系管理员");
      }
      if (customer.getCustomerCode().equals(reqVo.getCustomerCode())){
        Map<String, List<String>> orgCodeListMap = mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
        String orgCode = null;
        String orgName = null;
        if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
          List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
          Map<String, String> orgNameMap = mdmOrgService.findOrgNameMap(orgCodeList);
          orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
          orgCode = String.join(",", orgCodeList);
        }
        userRedis.setCustcode(customer.getCustomerCode());
        userRedis.setCustname(customer.getCustomerName());
        userRedis.setOrgcode(orgCode);
        userRedis.setOrgname(orgName);
        mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
        mdmLoginRespVo.setCustomerName(customer.getCustomerName());
        mdmLoginRespVo.setOrgCode(orgCode);
        mdmLoginRespVo.setOrgName(orgName);
        mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
      }else {
        throw new BusinessException("客户编码不匹配，请联系管理员");
      }
    }
    userRedis.setFromtype(reqVo.getFromType());
    UserUtils.setUser(token, userRedis);
    HttpServletRequest request = HttpServletRequestUtil.getRequest();
    HttpServletResponse response = HttpServletRequestUtil.getResponse();
    CookiesUtil.doCoke(request, response, token, GlobalParam.TOKEN);
    mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), reqVo.getFromType(), DateUtil.dateNowHms());
    return mdmLoginRespVo;
  }

  @Override
  public void sendVerificationForLoginAndResetByMessage(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    String verification = mdmLoginHelpService.saveLoginVerificationCodeRelUser(reqVo.getFromType(), user.getUserName(), user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    //发送短信验证码
    mdmLoginHelpService.sendVerificationCode(reqVo.getFromType(), verification, user.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
  }

  @Override
  public void checkPhoneExistAndUsable(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    //校验锁定状态
    mdmLoginHelpService.checkLock(reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE);
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
    //校验用户类型
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    //校验用户状态
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public MdmLoginRespVo loginAndResetByPhoneVerification(MdmAppletLoginReqVo reqVo) {
    Assert.hasText(reqVo.getUserPhone(), "缺失手机号");
    Assert.hasText(reqVo.getVerificationCode(), "缺失验证码");
    String userName = mdmLoginHelpService.checkVerificationCode(reqVo.getFromType(), reqVo.getVerificationCode(), reqVo.getUserPhone(), LoginHelpUtil.AccountType.PHONE, LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    MdmUserRespVo user = mdmUserService.getUserForLogin(userName, null, null);
    Assert.isTrue(reqVo.getUserPhone().equals(user.getUserPhone()), "手机号关联用户发生变化，请重新登录");
    mdmLoginHelpService.checkUserType(user.getUserType(), reqVo.getFromType());
    mdmLoginHelpService.checkUserLogin(user.getEnableStatus(), user.getStartTime(), user.getEndTime());
    mdmLoginHelpService.unlock(user.getUserName(), user.getUserPhone(), user.getEmail());
    //修改密码
    mdmUserService.editPassword(userName,reqVo.getPassword());
    return doLoginThisSystem(user, reqVo, false, false, false);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void resetPasswordByPhone(String phoneCode, String password) {
    Assert.hasText(phoneCode, "缺失手机号");
    Assert.hasText(password, "缺失验证码");
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, phoneCode, null);
    //修改密码
    mdmUserService.editPassword(user.getUserName(), password);
  }

  @Override
  public MdmLoginTypeControlVo getLoginTypeControlConfig() {
    return mdmSystemLoginService.getLoginTypeControlConfig();
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void logout() {
    UserRedis user = UserUtils.getUser();
    if (user != null) {
      if (StringUtils.isNotEmpty(user.getOpenId())) {
        mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
      }
      UserUtils.logout();
    }
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void logoutFromType() {
    UserRedis user = UserUtils.getUser();
    if (user != null) {
      if (StringUtils.isNotEmpty(user.getOpenId())) {
        mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
      }
      UserUtils.logout(LoginFromTypeEnum.APPLET_SFA.getValue());
    }
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void logoutAll() {
    UserRedis user = UserUtils.getUser();
    if (user != null) {
      if (StringUtils.isNotEmpty(user.getOpenId())) {
        mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
      }
      UserUtils.deleteUser(user.getUsername());
    }
  }

  @Override
  public void sendTerminalVerificationByMessage(String phoneCode) {
    List<MdmTerminalVo> terminalVos = mdmTerminalMapper.findTerminalByMainContactPhone(phoneCode);
    Assert.isTrue(CollectionUtils.isEmpty(terminalVos), "该手机号已注册");
    /**
     * 1 生成验证码
     * 2 将验证存入到缓存中
     * 3 将验证码发送给该手机号码
     */
    String verificationCode = mdmLoginHelpService.generateVerificationCode();

    redisService.hset(RedisParam.REGISTER_PHONE_VERIFICATION + ":" + phoneCode, verificationCode, phoneCode, RedisParam.SECONDS_OF_FIVE_MINUTE);

    ShortMessage shortMessage = new ShortMessage();
    shortMessage.setPhoneNumbers(phoneCode);
    shortMessage.setTemplateParam("{\"code\":\"" + verificationCode + "\"}");
    //  发送手机号登录验证码
    String template = mdmDictDataService.getDictDataMap(DictConstant.MESSAGE_TEMPLATE).get(DictConstant.MESSAGE_TEMPLATE_SYSTEM_LOGIN);
    Assert.hasText(template, "未配置手机验证码注册短信模板");
    shortMessage.setTemplateCode(template);
    shortMessageFeign.sendMessage(shortMessage);
    log.debug("发送验证码成功：手机号：{}，验证码：{}", phoneCode, verificationCode);
  }

  @Override
  public Boolean VerificationPhoneByCode(String phoneCode,String verificationCode) {
    ValidateUtils.validate(phoneCode,"电话号码不能为空");
    ValidateUtils.validate(verificationCode,"验证码不能为空");
    String returnPhoneCode = null;
    /**
     * 从redis里面获取保存的电话号码信息
     */
    Object hget = redisService.hget(RedisParam.REGISTER_PHONE_VERIFICATION + ":" + phoneCode, verificationCode);
    if (hget != null) {
      redisService.del(RedisParam.REGISTER_PHONE_VERIFICATION + ":" + phoneCode);
      returnPhoneCode = (String) hget;
    }
    Assert.hasText(returnPhoneCode, "验证码错误或者验证码已过期");
    boolean result = StringUtils.equals(phoneCode, returnPhoneCode);
    return result;
  }

  @Override
  public void switchoverTerminal(MdmAppletLoginReqVo reqVo) {
    if (StringUtils.isNotEmpty(reqVo.getTerminalCode())){
      Assert.hasText(reqVo.getTerminalCode(), "终端编码不能为空");
    }
    //获取用户
    UserRedis user = UserUtils.getUser();
    String token = UserUtils.getToken();
    //获取终端信息
    List<MdmTerminalEntity> list = mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, reqVo.getTerminalCode()).list();
    if (!CollectionUtil.listNotEmptyNotSizeZero(list)){
      Assert.isNull(list,"未查询到终端信息");
    }
    //生成登录信息
    UserRedis userRedis = new UserRedis();
    userRedis.setUsername(user.getUsername());
    userRedis.setRealname(user.getRealname());
    userRedis.setUsertype(user.getUsertype());
    userRedis.setCustcode(list.get(0).getTerminalCode());
    userRedis.setCustname(list.get(0).getTerminalName());
    userRedis.setOrgcode(list.get(0).getOrgCode());
    userRedis.setFromtype(reqVo.getFromType());
    UserUtils.setUser(token, userRedis);
    HttpServletRequest request = HttpServletRequestUtil.getRequest();
    HttpServletResponse response = HttpServletRequestUtil.getResponse();
    CookiesUtil.doCoke(request, response, token, GlobalParam.TOKEN);
  }

  @Override
  public List<MdmTerminalVo> getTerminalByPhone(String phoneCode) {
    Assert.hasText(phoneCode, "缺失手机号");
    //获取用户
    MdmUserRespVo user = mdmUserService.getUserForLogin(null, phoneCode, null);
    List<MdmTerminalVo> terminalList = mdmTerminalMapper.findTerminalByUserName(user.getUserName());
    if (CollectionUtil.listNotEmptyNotSizeZero(terminalList)){
      List<String> terminalCodeList = new ArrayList<>();
      terminalList.forEach(x ->{
        terminalCodeList.add(x.getTerminalCode());
      });
      terminalList = mdmTerminalService.queryTerminalAndAttachByCode(terminalCodeList);
    }
    return terminalList;
  }


  /**
   * 执行登录操作
   *
   * @param user            用户信息
   * @param reqVo           请求参数
   * @param getLastLoginLog 获取上一次登录日志
   * @param resetPassword   强制下一次登录修改密码
   * @param bind            绑定微信
   * @return
   */
  protected MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, MdmAppletLoginReqVo reqVo, boolean getLastLoginLog, boolean resetPassword, boolean bind) {

    if (bind && StringUtils.isNotEmpty(reqVo.getOpenId())) {
      //绑定微信与用户
      MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
      CrmBeanUtil.copyProperties(reqVo, bindReq);
      bindReq.setUserName(user.getUserName());
      bindReq.setOriginModule(reqVo.getFromType());
      bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
      bindReq.setOpenId(reqVo.getOpenId());
      mdmUserRelWeChatService.bind(bindReq);
    }

    MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();

    String token = UUID.randomUUID().toString().replaceAll("-", "");
    //生成登录信息
    UserRedis userRedis = new UserRedis();
    userRedis.setUsername(user.getUserName());
    userRedis.setRealname(user.getFullName());
    userRedis.setUsertype(user.getUserType());
    String openId=reqVo.getOpenId();
    if(StringUtils.isNotBlank(openId)){
    }else{
      List<MdmUserRelWeChatRespVo> weChats = mdmUserRelWeChatService.getBindWeChatListByUserName(user.getUserName(),reqVo.getFromType());
      if(!CollectionUtil.listEmpty(weChats)){
        openId=weChats.get(0).getOpenId();
      }
    }
    userRedis.setOpenId(openId);
    mdmLoginRespVo.setUserCode(user.getUserCode());
    mdmLoginRespVo.setLoginUserToken(token);
    mdmLoginRespVo.setUserName(user.getUserName());
    mdmLoginRespVo.setFullName(user.getFullName());
    mdmLoginRespVo.setUserType(user.getUserType());
    mdmLoginRespVo.setLanguage(userRedis.getLanguage());
    mdmLoginRespVo.setOpenId(openId);
    if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
      //获取当前职位
      MdmPositionUserOrgRespVo positionUserOrg = mdmPositionService.getCurrentPositionByUserName(user.getUserName());
      userRedis.setPoscode(positionUserOrg.getPositionCode());
      userRedis.setPosname(positionUserOrg.getPositionName());
      userRedis.setOrgcode(positionUserOrg.getOrgCode());
      userRedis.setOrgname(positionUserOrg.getOrgName());
      mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
      mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
      mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
      mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
    } else if (UserTypeEnum.TERMINAL.getCode().equals(user.getUserType())) {
      List<MdmTerminalVo> terminalList = mdmTerminalService.findTerminalByUserName(user.getUserName());
      if (CollectionUtil.listEmpty(terminalList)) {
        throw new BusinessException("当前账号未关联可用的终端，请联系管理员");
      }

      List<MdmTerminalLoginVo> mdmTerminalLoginVos = CrmBeanUtil.copyList(terminalList, MdmTerminalLoginVo.class);
      mdmLoginRespVo.setTerminalVoList(mdmTerminalLoginVos);

      //todo 有多个终端信息 先默认返回第一个终端信息 规则以后再定
      MdmTerminalVo mdmTerminalVo = terminalList.get(0);
      if(mdmTerminalVo!=null){
        Assert.isTrue(!MdmBpmStatusEnum.APPROVAL.getValue().equals(mdmTerminalVo.getActApproveStatus()), "终端注册信息审核中，请耐心等待");
        Assert.isTrue(!MdmBpmStatusEnum.REJECT.getValue().equals(mdmTerminalVo.getActApproveStatus()), "终端注册信息审核未通过，请重新注册");
        userRedis.setCustcode(mdmTerminalVo.getTerminalCode());
        userRedis.setCustname(mdmTerminalVo.getTerminalName());
        userRedis.setOrgcode(mdmTerminalVo.getOrgCode());
        userRedis.setOrgname(mdmTerminalVo.getOrgName());
        mdmLoginRespVo.setCustomerCode(mdmTerminalVo.getTerminalCode());
        mdmLoginRespVo.setCustomerName(mdmTerminalVo.getTerminalName());
        mdmLoginRespVo.setOrgCode(mdmTerminalVo.getOrgCode());
        mdmLoginRespVo.setOrgName(mdmTerminalVo.getOrgName());
      }

    }else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUserType())) {
      MdmCustomerMsgRespVo customer = mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
      if (customer == null) {
        throw new BusinessException("当前账号未关联可用的客户，请联系管理员");
      }
      Map<String, List<String>> orgCodeListMap = mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
      String orgCode = null;
      String orgName = null;
      if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
        List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
        Map<String, String> orgNameMap = mdmOrgService.findOrgNameMap(orgCodeList);
        orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
        orgCode = String.join(",", orgCodeList);
      }
      userRedis.setCustcode(customer.getCustomerCode());
      userRedis.setCustname(customer.getCustomerName());
      userRedis.setOrgcode(orgCode);
      userRedis.setOrgname(orgName);
      mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
      mdmLoginRespVo.setCustomerName(customer.getCustomerName());
      mdmLoginRespVo.setOrgCode(orgCode);
      mdmLoginRespVo.setOrgName(orgName);
      mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
    }

    userRedis.setFromtype(reqVo.getFromType());
    UserUtils.setUser(token, userRedis);
    HttpServletRequest request = HttpServletRequestUtil.getRequest();
    HttpServletResponse response = HttpServletRequestUtil.getResponse();
    CookiesUtil.doCoke(request, response, token, GlobalParam.TOKEN);
    if (getLastLoginLog) {
      MdmUserLoginLogRespVo lastLoginLog = mdmUserLoginLogService.getLastLoginLog(user.getUserName(), reqVo.getFromType());
      mdmLoginRespVo.setLastLoginLog(lastLoginLog);
    }
    if (resetPassword) {
      mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
      mdmUserService.setUserForceChangePassword(user.getUserName());
    } else {
      if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
        mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
      }
    }
    mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), reqVo.getFromType(), DateUtil.dateNowHms());
    return mdmLoginRespVo;
  }
}
