package com.biz.crm.material.mapper;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.provider.MdmMaterialProvider;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MaterialMdmPaginationDto;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialSelectReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialSelectRespVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
public interface MdmMaterialMapper extends BaseMapper<MdmMaterialEntity> {


    /**
     * 分页查询
     *
     * @param page page
     * @param vo   vo
     * @return list
     */
    List<MdmMaterialRespVo> findList(Page<MdmMaterialRespVo> page, @Param("vo") MdmMaterialReqVo vo);
    /**
     * 分页查询(provider)
     *
     * @param page page
     * @param vo   vo
     * @return list
     */
    @SelectProvider(type = MdmMaterialProvider.class,method = "findListProvider")
    List<MdmMaterialRespVo> findListProvider(Page<MdmMaterialRespVo> page, @Param("vo") MdmMaterialReqVo vo);

    /**
     * 精确查询
     *
     * @param wrapper wrapper
     * @return MdmMaterialRespVo
     */
    MdmMaterialRespVo findOne(@Param("ew") QueryWrapper<MdmMaterialEntity> wrapper);

    /**
     * 通用分页查询
     *
     * @param page    page
     * @param mdmMaterialOrgSearchReqVo wrapper
     * @return list
     */
    List<MdmMaterialRespVo> pageCondition(Page<MdmMaterialRespVo> page, @Param("vo") MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo);

    /**
     * 物料下拉框
     *
     * @param reqVo
     * @param includeList 只查询这些编码
     * @param excludeList 排除这些编码
     * @return
     */
    List<MdmMaterialSelectRespVo> materialSelectList(Page<MdmMaterialSelectRespVo> page, @Param("vo") MdmMaterialSelectReqVo reqVo, @Param("includeList") List<String> includeList, @Param("excludeList") List<String> excludeList);

    /**
     * 根据物料组编码查询物料信息
     * @param groupCode
     * @return
     */
    List<MdmMaterialRespVo> findMaterialByMaterialGroupCode(@Param("groupCode") String groupCode);

    /**
     * 给cps提供物料接口信息
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmMaterialRespVo> findCpsList(Page<MdmMaterialRespVo> page,  @Param("vo") MaterialMdmPaginationDto reqVo);
}
