package com.biz.crm.material.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import java.util.List;

/**
 * @ClassName: MdmMaterialGroupService
 * @Author: yangfan
 * @Description: 物料组service
 * @Date: 2021/8/19 11:33
 * @Version: 1.0
 */
public interface MdmMaterialGroupService {

  /**
   * 分页查询物料组信息
   * @param groupReqVo
   * @return
   */
  PageResult<MdmMaterialGroupRespVo> findList(MdmMaterialGroupReqVo groupReqVo);

  /**
   * 查询物料组详情
   * @param id
   * @param materialGroupCode
   * @return
   */
  MdmMaterialGroupRespVo detail(String id, String materialGroupCode);

  /**
   * 物料组新增
   * @param mdmMaterialGroupReqVo
   */
  void save(MdmMaterialGroupReqVo mdmMaterialGroupReqVo);

  /**
   * 物料组更新
   * @param mdmMaterialGroupReqVo
   */
  void update(MdmMaterialGroupReqVo mdmMaterialGroupReqVo);

  /**
   * 批量删除物料组信息
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启动物料组信息
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用物料组信息
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 提供给cps物料组的分页查询方法
   * @param groupReqVo
   * @return
   */
  PageResult<MdmMaterialGroupRespVo> pageGroupCpsList(MdmMaterialGroupReqVo groupReqVo);
}
