package com.biz.crm.material.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.model.MdmMaterialMediaEntity;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialMediaRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import java.util.List;

/**
 * @ClassName: MdmMaterialMediaService
 * @Author: yangfan
 * @Description: 物料照片信息service接口
 * @Date: 2021/8/16 15:35
 * @Version: 1.0
 */


public interface MdmMaterialMediaService extends IService<MdmMaterialMediaEntity> {

  /**
   * 根据物料id或者物料code 获取照片信息
   * @param materialId
   * @param materialCode
   * @return
   */
  List<MdmMaterialMediaRespVo> findMediaListByCondition(String materialId,String materialCode);

  /**
   *
   * id集合查主照片
   * @param ids
   * @author rentao
   * @date
   */
  List<MdmMaterialMediaRespVo> findMediaListByIds(List<String> ids);

}
