package com.biz.crm.material.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.*;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
public interface MdmMaterialService extends IService<MdmMaterialEntity> {

    /**
     * 列表
     *
     * @param mdmMaterialReqVo 条件
     * @return PageResult<MdmMaterialRespVo>
     */
    PageResult<MdmMaterialRespVo> findList(MdmMaterialReqVo mdmMaterialReqVo);

    /**
     * 详情
     *
     * @param id           id
     * @param materialCode 物料编码
     * @return
     */
    MdmMaterialRespVo detail(String id, String materialCode);

    /**
     * 新增
     *
     * @param mdmMaterialReqVo 新增实例
     */
    void save(MdmMaterialReqVo mdmMaterialReqVo);

    /**
     * 更新
     *
     * @param mdmMaterialReqVo 更新实例
     */
    void update(MdmMaterialReqVo mdmMaterialReqVo);

    /**
     * 删除
     *
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 物料下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmMaterialSelectRespVo> materialSelect(MdmMaterialSelectReqVo reqVo);

    /**
     * 查询物料
     *
     * @param mdmMaterialOrgSearchReqVo privilege
     * @return list
     */
    List<MdmMaterialPriceRespVo> findCurrentAndSubMaterialList(MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo);

    /**
     * 根据物料组编码查询物料信息
     * @param groupCode
     * @return
     */
    List<MdmMaterialRespVo> findMaterialByMaterialGroupCode(String groupCode);

    /**
     * 分页查询物料信息(带有此物料所有的上级产品层级信息)
     * @param mdmMaterialReqVo
     * @return
     */
    PageResult<MdmMaterialRespVo> findCpsList(MaterialMdmPaginationDto mdmMaterialReqVo);

}

