package com.biz.crm.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.mapper.MdmMaterialMediaMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.model.MdmMaterialMediaEntity;
import com.biz.crm.material.service.MdmMaterialMediaService;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.material.MdmMaterialMediaRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

/**
 * @ClassName: MdmMaterialMediaServiceImpl
 * @Author: yangfan
 * @Description: 物料照片实现impl
 * @Date: 2021/8/16 17:00
 * @Version: 1.0
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmMaterialServiceExpandImpl")
public class MdmMaterialMediaServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmMaterialMediaMapper, MdmMaterialMediaEntity> implements MdmMaterialMediaService {

  @Override
  public List<MdmMaterialMediaRespVo> findMediaListByCondition(String materialId, String materialCode) {
    AssertUtils.isTrue(StringUtils.isNotEmpty(materialId) || StringUtils.isNotEmpty(materialCode),"物料id或者物料编码不能为空");
    LambdaQueryWrapper<MdmMaterialMediaEntity> objectLambdaQueryWrapper = Wrappers.lambdaQuery();
    objectLambdaQueryWrapper.eq(StringUtils.isNotEmpty(materialCode),MdmMaterialMediaEntity::getMaterialCode,materialCode)
        .eq(StringUtils.isNotEmpty(materialId),MdmMaterialMediaEntity::getMaterialId, materialId);
    List<MdmMaterialMediaEntity> list = this.list(objectLambdaQueryWrapper);
    List<MdmMaterialMediaRespVo> mdmMaterialMediaRespVos = CrmBeanUtil.copyList(list, MdmMaterialMediaRespVo.class);
    return mdmMaterialMediaRespVos;
  }

  @Override
  public List<MdmMaterialMediaRespVo> findMediaListByIds(List<String> ids) {
    AssertUtils.isTrue(CollectionUtil.listNotEmptyNotSizeZero(ids),"物料id或者物料编码不能为空");
    LambdaQueryWrapper<MdmMaterialMediaEntity> objectLambdaQueryWrapper = Wrappers.lambdaQuery();
    objectLambdaQueryWrapper.in(MdmMaterialMediaEntity::getMaterialId,ids)
        .eq(MdmMaterialMediaEntity::getBusinessType, "central");
    List<MdmMaterialMediaEntity> list = this.list(objectLambdaQueryWrapper);
    List<MdmMaterialMediaRespVo> mdmMaterialMediaRespVos = CrmBeanUtil.copyList(list, MdmMaterialMediaRespVo.class);
    return mdmMaterialMediaRespVos;
  }
}
