package com.biz.crm.mdmbuglistmanagement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.mdmbuglistmanagement.mapper.MdmBugListManagementMapper;
import com.biz.crm.mdmbuglistmanagement.model.MdmBugListManagementEntity;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author maoshen
 * @date 2021/1/29.
 */
@Slf4j
@Service
public class BugManagementServiceHelp {
    @Resource
    private MdmBugListManagementMapper mdmBugListManagementMapper;

    public Map<String, Map<String, String>> getDicts() {
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.BUG_OWNING_MODULE);
        dictCodes.add(TpmGlobalDictConstants.RELEASE_VERSION);
        dictCodes.add(TpmGlobalDictConstants.SYS_TASK);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }
    public void setStatus(Map<String, String> globalMap, MdmBugListManagementRespVo o) {
        Map<String,Map<String,String>> helpMap = this.getDicts();
        if (StringUtils.isNotEmpty(o.getCodeByPhone())){
            o.setChargeMan(Optional.ofNullable(helpMap.get(TpmGlobalDictConstants.SYS_TASK)).orElse(Maps.newHashMap()).get(o.getCodeByPhone()));
        }
        if (StringUtils.isNotBlank(o.getReleaseVersion())){
            o.setReleaseVersionDesc(Optional.ofNullable(helpMap.get(TpmGlobalDictConstants.RELEASE_VERSION))
                    .orElse(Maps.newHashMap()).get(o.getReleaseVersion()));
        }
        if (StringUtils.isNotBlank(o.getOwningModule())){
            o.setOwningModuleDesc(Optional.ofNullable(helpMap.get(TpmGlobalDictConstants.BUG_OWNING_MODULE))
                    .orElse(Maps.newHashMap()).get(o.getOwningModule()));
        }
        if (StringUtils.isNotEmpty(o.getIsBackendFix())) {
            o.setIsBackendFixDesc(globalMap.get(o.getIsBackendFix()));
        }
        if (StringUtils.isNotEmpty(o.getIsForeEndFix())) {
            o.setIsForeEndFixDesc(globalMap.get(o.getIsForeEndFix()));
        }
        if (StringUtils.isNotEmpty(o.getIsDevTesting())) {
            o.setIsDevTestingDesc(globalMap.get(o.getIsDevTesting()));
        }
        if (StringUtils.isNotEmpty(o.getIsDevPassTest())) {
            o.setIsDevPassTestDesc(globalMap.get(o.getIsDevPassTest()));
        }
        if (StringUtils.isNotEmpty(o.getIsBackendArrUat())) {
            o.setIsBackendArrUatDesc(globalMap.get(o.getIsBackendArrUat()));
        }
        if (StringUtils.isNotEmpty(o.getIsForeEndArrUat())) {
            o.setIsForeEndArrUatDesc(globalMap.get(o.getIsForeEndArrUat()));
        }
        if (StringUtils.isNotEmpty(o.getIsUatTesting())) {
            o.setIsUatTestingDesc(globalMap.get(o.getIsUatTesting()));
        }
        if (StringUtils.isNotEmpty(o.getIsUatPassTest())) {
            o.setIsUatPassTestDesc(globalMap.get(o.getIsUatPassTest()));
        }
        if (StringUtils.isNotEmpty(o.getIsBackendArrPro())) {
            o.setIsBackendArrProDesc(globalMap.get(o.getIsBackendArrPro()));
        }
        if (StringUtils.isNotEmpty(o.getIsForeEndArrPro())) {
            o.setIsForeEndArrProDesc(globalMap.get(o.getIsForeEndArrPro()));
        }
        if (StringUtils.isNotEmpty(o.getIsProTesting())) {
            o.setIsProTestingDesc(globalMap.get(o.getIsProTesting()));
        }
        if (StringUtils.isNotEmpty(o.getIsProPassTest())) {
            o.setIsProPassTestDesc(globalMap.get(o.getIsProPassTest()));
        }
        if (StringUtils.isNotEmpty(o.getIsComplete())) {
            o.setIsCompleteDesc(globalMap.get(o.getIsComplete()));
        }
        if (StringUtils.isNotEmpty(o.getIsUrgent())){
            o.setIsUrgentDesc(globalMap.get(o.getIsUrgent()));
        }
        if (StringUtils.isNotEmpty(o.getIsWaitComplete())){
            o.setIsWaitCompleteDesc(globalMap.get(o.getIsWaitComplete()));
        }
        if (StringUtils.isNotEmpty(o.getIsDevWaitTest())){
            o.setIsDevWaitTestDesc(globalMap.get(o.getIsDevWaitTest()));
        }
        if (StringUtils.isNotEmpty(o.getIsUatWaitTest())){
            o.setIsUatWaitTestDesc(globalMap.get(o.getIsUatWaitTest()));
        }
        if (StringUtils.isNotEmpty(o.getIsProWaitTest())){
            o.setIsProWaitTestDesc(globalMap.get(o.getIsProWaitTest()));
        }
    }

    public void checkData(MdmBugListManagementReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getBugCode(),"请输入bug编码");
        AssertUtils.isNotEmpty(reqVo.getBugName(),"BugName不能为空");
        AssertUtils.isNotEmpty(reqVo.getCodeByPhone(),"负责人手机号不能为空");
        Map<String,Map<String,String>> helpMap = this.getDicts();
        reqVo.setChargeMan(Optional.ofNullable(helpMap.get(TpmGlobalDictConstants.SYS_TASK)).orElse(Maps.newHashMap()).get(reqVo.getCodeByPhone()));
        if (StringUtils.isBlank(reqVo.getIsBackendFix())){
            reqVo.setIsBackendFix(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsForeEndFix())){
            reqVo.setIsForeEndFix(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsBackendArrPro())){
            reqVo.setIsBackendArrPro(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsForeEndArrPro())){
            reqVo.setIsForeEndArrPro(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsBackendArrUat())){
            reqVo.setIsBackendArrUat(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsForeEndArrUat())){
            reqVo.setIsForeEndArrUat(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsDevTesting())){
            reqVo.setIsDevTesting(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsDevPassTest())){
            reqVo.setIsDevPassTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsProTesting())){
            reqVo.setIsProTesting(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsProPassTest())){
            reqVo.setIsProPassTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsUatTesting())){
            reqVo.setIsUatTesting(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsUatPassTest())){
            reqVo.setIsUatPassTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsUrgent())){
            reqVo.setIsUrgent(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsComplete())){
            reqVo.setIsComplete(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsWaitComplete())){
            reqVo.setIsWaitComplete(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsDevWaitTest())){
            reqVo.setIsDevWaitTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsUatWaitTest())){
            reqVo.setIsUatWaitTest(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isBlank(reqVo.getIsProWaitTest())){
            reqVo.setIsProWaitTest(GlobalWhetherEnum.NO.getCode());
        }
        this.checkExist(reqVo);
    }

    private void checkExist(MdmBugListManagementReqVo reqVo) {
        LambdaQueryWrapper<MdmBugListManagementEntity> wrapper = Wrappers.<MdmBugListManagementEntity>lambdaQuery()
                .eq(MdmBugListManagementEntity::getBugCode,reqVo.getBugCode());
        if (StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(MdmBugListManagementEntity::getId,reqVo.getId());
        }
        if (CollectionUtils.isNotEmpty(mdmBugListManagementMapper.selectList(wrapper))){
            throw new BusinessException("编码重复");
        }
    }

    /**
     * map 反转 不在数据库存企业微信绑定得个人真实手机号
     * @param x
     */
    public void setPhone(MdmBugListManagementReqVo x) {
        Map<String,String> phoneMap = Optional.ofNullable(this.getDicts().get(TpmGlobalDictConstants.SYS_TASK)).orElse(Maps.newHashMap());
        Set<String> valueSet = Sets.newHashSet(phoneMap.values());
        if (valueSet.size() != phoneMap.size()){
            throw new BusinessException("有相同姓名负责人，请区分");
        }
        Map<String,String> nameToPhoneMap = phoneMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue,
                Map.Entry::getKey));
        if (StringUtils.isNotBlank(x.getChargeMan())){
            x.setCodeByPhone(nameToPhoneMap.get(x.getChargeMan()));
        }
    }
}