package com.biz.crm.mdmbuglistmanagement.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.GlobalExceptionHandler;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.wx.WxMsgUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.mdmbuglistmanagement.model.MdmBugListManagementEntity;
import com.biz.crm.mdmbuglistmanagement.mapper.MdmBugListManagementMapper;
import com.biz.crm.mdmbuglistmanagement.service.IMdmBugListManagementService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * bug管理主表接口实现
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmBugListManagementServiceExpandImpl")
public class MdmBugListManagementServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmBugListManagementMapper, MdmBugListManagementEntity> implements IMdmBugListManagementService {

    @Resource
    private MdmBugListManagementMapper mdmBugListManagementMapper;
    @Autowired
    private BugManagementServiceHelp helpService;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<MdmBugListManagementRespVo> findList(MdmBugListManagementReqVo reqVo){
        Page<MdmBugListManagementRespVo> page = PageUtil.buildPage(reqVo.getPageNum(),reqVo.getPageSize());
        List<MdmBugListManagementRespVo> list = mdmBugListManagementMapper.findList(page, reqVo);
        Map<String, String> globalMap = getGlobalMap();
        if (CollectionUtils.isNotEmpty(list)){
            list.forEach(o->{
                helpService.setStatus(globalMap, o);
            });
        }
        return PageResult.<MdmBugListManagementRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     *
     * @return
     */
    private Map<String, String> getGlobalMap() {
        Map<String,String> globalMap = Maps.newHashMap();
        globalMap.put(GlobalWhetherEnum.YES.getCode(),GlobalWhetherEnum.YES.getDes());
        globalMap.put(GlobalWhetherEnum.NO.getCode(),GlobalWhetherEnum.NO.getDes());
        return globalMap;
    }


    /**
     * 查询
     * @param id ids
     * @return mdmBugListManagementRespVo
     */
    @Override
    public MdmBugListManagementRespVo query(String id){
        if (StringUtils.isNotBlank(id)){
            MdmBugListManagementRespVo mdmBugListManagementRespVo = CrmBeanUtil.copy(mdmBugListManagementMapper.selectOne(Wrappers
                    .lambdaQuery(new MdmBugListManagementEntity())
                    .eq(MdmBugListManagementEntity::getId,id)),MdmBugListManagementRespVo.class);
            Map<String, String> globalMap = getGlobalMap();
            helpService.setStatus(globalMap,mdmBugListManagementRespVo);
            return mdmBugListManagementRespVo;
        }
        return new MdmBugListManagementRespVo();
    }

    /**
     * 新增
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmBugListManagementReqVo reqVo){
        helpService.checkData(reqVo);
        MdmBugListManagementEntity entity = CrmBeanUtil.copy(reqVo,MdmBugListManagementEntity.class);
        this.save(entity);
        if (entity.getIsUrgent().equals(GlobalWhetherEnum.YES.getCode())){
            WxMsgUtil.sendBugMsg(reqVo);
        }
    }


    /**
     * 更新
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmBugListManagementReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getId(),CommonException.IDS_NULL);
        List<MdmBugListManagementEntity> listManagementEntities = mdmBugListManagementMapper.selectList(Wrappers.<MdmBugListManagementEntity>lambdaQuery()
                .eq(MdmBugListManagementEntity::getId,reqVo.getId()));
        AssertUtils.isTrue(CollectionUtils.size(listManagementEntities) == 1,"修改数据异常");
        if (StringUtils.equals(listManagementEntities.get(0).getIsComplete(),GlobalWhetherEnum.YES.getCode())){
            throw new BusinessException("已经发布到远程仓库的数据不可修改");
        }
        helpService.checkData(reqVo);
        MdmBugListManagementEntity entity = CrmBeanUtil.copy(reqVo,MdmBugListManagementEntity.class);
        this.updateById(entity);
        if (entity.getIsUrgent().equals(GlobalWhetherEnum.YES.getCode())){
            WxMsgUtil.sendBugMsg(reqVo);
        }
    }


    /**
     * 批量后端已解决
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchBackEndFix(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsBackendFix(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);

    }

    /**
     * 批量 dev 测试中
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchDevTest(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsDevTesting(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量 dev 测试通过
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchDevTestPass(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsDevPassTest(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);

    }

    /**
     * 批量 前端解决
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchForeEndFix(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsForeEndFix(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量发布到远程仓库
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchComplete(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsComplete(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
        });
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量 uat 测试通过
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchUatTestPass(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsUatPassTest(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量 uat 测试中
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchUatTest(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsUatTesting(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量 pro 测试中
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchProTest(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsProTesting(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);

    }
    /**
     * 批量 pro 测试通过
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchProTestPass(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsProPassTest(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量 后端部署到 uat
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchBackEndUat(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsBackendArrUat(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);

    }

    /**
     *  批量 后端部署到 uat
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchBackEndPro(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsBackendArrPro(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     * 批量 前端部署到 uat
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchForeEndUat(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsForeEndArrUat(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     *  批量 前端发布到 pro
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchForeEndPro(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsForeEndArrPro(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
    }

    /**
     *  批量 紧急
     * @param ids ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void batchUrgent(List<String> ids) {
        AssertUtils.isNotEmpty(ids,"请至少选择一条您要操作的数据");
        List<MdmBugListManagementEntity> entities = mdmBugListManagementMapper.selectBatchIds(ids);
        // 记录可修改部分
        List<MdmBugListManagementEntity> updateEntities = Lists.newArrayList();
        List<MdmBugListManagementReqVo>  listManagementReqVos = Lists.newArrayList();
        Set<String> canNotUpdateCodes = Sets.newHashSet();
        entities.forEach(o->{
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.NO.getCode())){
                o.setIsUrgent(GlobalWhetherEnum.YES.getCode());
                updateEntities.add(o);
                listManagementReqVos.add(CrmBeanUtil.copy(o,MdmBugListManagementReqVo.class));
            }
            if (StringUtils.equals(o.getIsComplete(),GlobalWhetherEnum.YES.getCode())){
                canNotUpdateCodes.add(o.getBugCode());
            }
        });
        if (CollectionUtils.isNotEmpty(canNotUpdateCodes)){
            String splitSetWithComma = StringUtils.join(canNotUpdateCodes, "、");
            throw new BusinessException("禅道号: "+splitSetWithComma+",已经发布到远程仓库，不可修改");
        }
        this.updateBatchById(updateEntities);
        if (CollectionUtils.isNotEmpty(listManagementReqVos)){
            listManagementReqVos.forEach(WxMsgUtil::sendBugMsg);

        }
    }
    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(MdmBugListManagementReqVo reqVo){
        //设置状态为启用
        List<MdmBugListManagementEntity> mdmBugListManagementEntities = mdmBugListManagementMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmBugListManagementEntities)){
            mdmBugListManagementEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmBugListManagementEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(MdmBugListManagementReqVo reqVo){
        //设置状态为禁用
        List<MdmBugListManagementEntity> mdmBugListManagementEntities = mdmBugListManagementMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmBugListManagementEntities)){
                mdmBugListManagementEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmBugListManagementEntities);
    }

    @Override
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<MdmBugListManagementEntity> listManagementEntities = mdmBugListManagementMapper.selectBatchIds(ids);
        List<String> deleteIds = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(listManagementEntities)){
           listManagementEntities.forEach(o -> {
                deleteIds.add(o.getId());
            });
            mdmBugListManagementMapper.deleteBatchIds(deleteIds);
        }
    }
}
