package com.biz.crm.mqlog.controller;

import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.mq.MdmMqMessageLogVo;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.mq.mqlog.MdmMqMessageLogEs;
import com.biz.crm.mq.mqlog.MdmMqMessageLogRepository;
import com.biz.crm.mqlog.req.MqLogQueryReq;
import com.biz.crm.mqlog.service.MdmMqMessageLogService;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


/**
 *  @author: luoqi
 *  @Date: 2020-9-27 11:17
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@RestController
@RequestMapping("/mqmessagelog")
@Api(tags = "mq消息日志")
public class MdmMqMessageLogController {
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Resource
    private MdmMqMessageLogRepository mdmMqMessageLogRepository;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MdmMqMessageLogService mdmMqMessageLogService;

    @ApiOperation("插入MQ日志")
    @PostMapping("/save")
    public Result<String> save(@RequestBody MdmMqMessageLogVo mdmMqMessageLogVo) {
        MdmMqMessageLogEs logEntity = CrmBeanUtil.copy(mdmMqMessageLogVo, MdmMqMessageLogEs.class);
        mdmMqMessageLogRepository.save(logEntity);
        Result<String> result = new Result<>();
        result.setResult(logEntity.getId());
        return result;
    }

    @ApiOperation("更新MQ日志")
    @PostMapping("/updateById")
    public void updateById(@RequestParam("id") String id) {
         Object o = redisService.get(RedisParam.MQ_MESSAGE+id);
         if(o!=null){
             MdmMqMessageLogVo mdmMqMessageLogVo = (MdmMqMessageLogVo)o;
             MdmMqMessageLogEs logEntity = CrmBeanUtil.copy(mdmMqMessageLogVo, MdmMqMessageLogEs.class);
             logEntity.setCreateDate(DateUtil.formatDate());
             logEntity.setCreateDateSecond(DateUtil.dateNowStrHms());
             mdmMqMessageLogRepository.save(logEntity);
             redisService.del(RedisParam.MQ_MESSAGE+id);
         }
    }

    @ApiOperation("查询MQ日志")
    @PostMapping("/getbyid")
    public Result<MdmMqMessageLogVo> getById(@RequestParam("id") String id) {
        MdmMqMessageLogEs logEntity = mdmMqMessageLogRepository.findById(id).get();
        if(null == logEntity){
            return null;
        }
        return Result.ok(CrmBeanUtil.copy(logEntity, MdmMqMessageLogVo.class));
    }

    @ApiOperation("查询MQ日志分页")
    @PostMapping("/getMqMessageLogPage")
    public Result<PageResult<MdmMqMessageLogEs>> getMqMessageLogPage(@RequestBody MqLogQueryReq mqLogQueryReq) {
        //执行,返回包装结果的分页
        org.springframework.data.domain.Page<MdmMqMessageLogEs> list = this.mdmMqMessageLogRepository.search(mqLogQueryReq.buildQuery());

        PageResult<MdmMqMessageLogEs> pageResult = PageResult.<MdmMqMessageLogEs>builder()
                .data(list.getContent())
                .count(list.getTotalElements())
                .build();


        return Result.ok(pageResult);
    }
}
