package com.biz.crm.mqlog.controller;

import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;


/**
 *
 *  @author: luoqi
 *  @Date: 2020-9-30 17:48
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.TEST,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.TEST + "${rocketmq.environment-variable}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY)
public class TestRocketMQConsumer extends AbstractRocketMQConsumer {

    /**
     * 消费消息
     *
     * @param message
     * @return
     */
    @Override
    protected Object handleMessage(RocketMQMessageBody message) {
        String logStr = "TestRocketMQConsumer -> 成功消费消息:" + message.getMsgBody();
        log.warn(logStr);
        return logStr;
    }

}
