package com.biz.crm.mqlog.job;

import com.biz.crm.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.mqlog.job
 * @Description: 系统定时清除es日志
 * @date 2021/3/15 下午1:56
 */
@EnableScheduling
@Component
@Slf4j
public class DeleteMqLog {
    //每天凌晨一点执行
    @Scheduled(cron = "0 0 1 * * ?")
    public void deleteData() {

        log.info("按月清楚mq 日志记录:"+ DateUtil.date2Str(new SimpleDateFormat("yyyy-MM")));

    }


}
